/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.meta;

import org.netbeans.modules.db.dataview.meta.DBObject;
import org.netbeans.modules.db.dataview.meta.DBTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DBColumn
extends DBObject<DBTable>
implements Comparable {
    public static final int POSITION_UNKNOWN = Integer.MIN_VALUE;
    private boolean foreignKey;
    private int jdbcType;
    private String typeName;
    private String columnName;
    private boolean nullable;
    private boolean editable = true;
    private int ordinalPosition = Integer.MIN_VALUE;
    private boolean primaryKey;
    private int precision;
    private int scale;
    private boolean generated;
    private int displaySize;
    private String defaultValue;

    public DBColumn(DBTable dBTable, String string, int n, String string2, int n2, int n3, boolean bl, boolean bl2) {
        this.setParentObject(dBTable);
        this.columnName = string;
        this.jdbcType = n;
        this.typeName = string2;
        this.precision = n3;
        this.scale = n2;
        this.nullable = bl;
        this.generated = bl2;
        this.editable = !dBTable.getName().equals("") && !bl2;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        if (object == this) {
            return 0;
        }
        String string = this.getDisplayName();
        string = string == null ? this.columnName : string;
        String string2 = null;
        if (!(object instanceof DBColumn)) {
            return -1;
        }
        DBColumn dBColumn = (DBColumn)object;
        string2 = dBColumn.getName();
        if (this.isPrimaryKey() && !dBColumn.isPrimaryKey()) {
            return -1;
        }
        if (!this.isPrimaryKey() && dBColumn.isPrimaryKey()) {
            return 1;
        }
        if (this.isForeignKey() && !dBColumn.isForeignKey()) {
            return -1;
        }
        if (!this.isForeignKey() && dBColumn.isForeignKey()) {
            return 1;
        }
        return string != null ? string.compareTo(string2) : (string2 != null ? 1 : -1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DBColumn)) {
            return false;
        }
        DBColumn dBColumn = (DBColumn)object;
        boolean bl = super.equals(object);
        bl &= this.columnName != null ? this.columnName.equals(dBColumn.getName()) : dBColumn.getName() == null;
        return bl &= this.jdbcType == dBColumn.getJdbcType() && this.primaryKey == dBColumn.isPrimaryKey() && this.foreignKey == dBColumn.isForeignKey() && this.nullable == dBColumn.isNullable() && this.scale == dBColumn.getScale() && this.precision == dBColumn.getPrecision() && this.ordinalPosition == dBColumn.getOrdinalPosition();
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null && this.displayName.trim().length() != 0 ? this.displayName.trim() : this.columnName.trim();
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.columnName;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getDisplaySize() {
        return this.displaySize;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDisplaySize(int n) {
        this.displaySize = n;
    }

    public String getQualifiedName(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(50);
        DBTable dBTable = (DBTable)this.getParentObject();
        stringBuilder.append(bl ? dBTable.getQuoter().quoteAlways(this.columnName) : dBTable.getQuoter().quoteIfNeeded(this.columnName));
        return stringBuilder.toString();
    }

    public int getScale() {
        return this.scale;
    }

    public int hashCode() {
        int n = super.hashCode();
        n += this.columnName != null ? this.columnName.hashCode() : 0;
        n += this.ordinalPosition;
        n += this.jdbcType + 10 * this.scale + 100 * this.precision;
        n += this.primaryKey ? 1 : 0;
        n += this.foreignKey ? 2 : 0;
        n += this.generated ? 4 : 0;
        return n += this.nullable ? 8 : 0;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isForeignKey() {
        return this.foreignKey;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean hasDefault() {
        return this.defaultValue != null && this.defaultValue.trim().length() != 0;
    }

    void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    void setForeignKey(boolean bl) {
        this.foreignKey = bl;
    }

    void setOrdinalPosition(int n) {
        this.ordinalPosition = n;
    }

    void setPrimaryKey(boolean bl) {
        this.primaryKey = bl;
    }

    void setEditable(boolean bl) {
        this.editable = bl;
    }
}

