/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.netbeans.modules.reglib.StatusData;
import org.netbeans.modules.reglib.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class StatusDocument {
    private static final String STATUS_DATA_SCHEMA = "/org/netbeans/modules/reglib/resources/status.xsd";
    private static final String STATUS_DATA_VERSION = "1.0";
    static final String ST_NODE_REGISTRATION_STATUS = "registration_status";
    static final String ST_ATTR_REGISTRATION_STATUS_VERSION = "version";
    static final String ST_NODE_STATUS = "status";
    static final String ST_NODE_TIMESTAMP = "timestamp";
    static final String ST_NODE_DELAY = "delay";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.reglib.StatusDocument");

    StatusDocument() {
    }

    static StatusData load(InputStream inputStream) throws IOException {
        Document document = StatusDocument.initializeDocument(inputStream);
        Element element = document.getDocumentElement();
        if (!element.getNodeName().equals(ST_NODE_REGISTRATION_STATUS)) {
            throw new IllegalArgumentException("Not a registration_status node \"" + element.getNodeName() + "\"");
        }
        String string = StatusDocument.getTextValue(element, ST_NODE_STATUS);
        String string2 = "later".equals(string) ? "later" : ("never".equals(string) ? "never" : ("registered".equals(string) ? "registered" : "unknown"));
        int n = 7;
        string = StatusDocument.getTextValue(element, ST_NODE_DELAY);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.log(Level.INFO, "Error: Cannot parse delay value:" + string, numberFormatException);
        }
        StatusData statusData = new StatusData(string2, n);
        Date date = Util.parseTimestamp(StatusDocument.getTextValue(element, ST_NODE_TIMESTAMP));
        statusData.setTimestamp(date);
        return statusData;
    }

    static void store(OutputStream outputStream, StatusData statusData) throws IOException {
        Document document = StatusDocument.initializeDocument();
        StatusDocument.addStatusNode(document, statusData);
        StatusDocument.transform(document, outputStream);
    }

    private static String getTextValue(Element element, String string) {
        Element element2;
        Node node;
        String string2 = "";
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() > 0 && (node = (element2 = (Element)nodeList.item(0)).getFirstChild()) != null) {
            string2 = node.getNodeValue();
        }
        return string2;
    }

    private static void addStatusNode(Document document, StatusData statusData) {
        Element element = document.getDocumentElement();
        Element element2 = document.createElement(ST_NODE_STATUS);
        element2.appendChild(document.createTextNode(statusData.getStatus()));
        element.appendChild(element2);
        Element element3 = document.createElement(ST_NODE_TIMESTAMP);
        element3.appendChild(document.createTextNode(Util.formatTimestamp(statusData.getTimestamp())));
        element.appendChild(element3);
        element3 = document.createElement(ST_NODE_DELAY);
        element3.appendChild(document.createTextNode(Integer.toString(statusData.getDelay())));
        element.appendChild(element3);
    }

    private static Document initializeDocument(InputStream inputStream) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL uRL = StatusDocument.class.getResource(STATUS_DATA_SCHEMA);
            Schema schema = schemaFactory.newSchema(uRL);
            Validator validator = schema.newValidator();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            validator.validate(new DOMSource(document));
            return document;
        }
        catch (SAXException sAXException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Error generated in parsing");
            illegalArgumentException.initCause(sAXException);
            throw illegalArgumentException;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            InternalError internalError = new InternalError("Error in creating the new document");
            internalError.initCause(parserConfigurationException);
            throw internalError;
        }
    }

    private static Document initializeDocument() throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(ST_NODE_REGISTRATION_STATUS);
            document.appendChild(element);
            element.setAttribute(ST_ATTR_REGISTRATION_STATUS_VERSION, STATUS_DATA_VERSION);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            InternalError internalError = new InternalError("Error in creating the new document");
            internalError.initCause(parserConfigurationException);
            throw internalError;
        }
    }

    private static void transform(Document document, OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", new Integer(3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.log(Level.INFO, "Warning: Attribute \"indent-number\" unsupported.", illegalArgumentException);
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"))));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            InternalError internalError = new InternalError("Error generated during transformation");
            internalError.initCause(unsupportedEncodingException);
            throw internalError;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            InternalError internalError = new InternalError("Error in creating the new document");
            internalError.initCause(transformerConfigurationException);
            throw internalError;
        }
        catch (TransformerException transformerException) {
            InternalError internalError = new InternalError("Error generated during transformation");
            internalError.initCause(transformerException);
            throw internalError;
        }
    }
}

