/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.WeakSharedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDManager {
    private final UIDStorage storage;
    private static final int UID_MANAGER_DEFAULT_CAPACITY;
    private static final int UID_MANAGER_DEFAULT_SLICED_NUMBER;
    private static final UIDManager instance;
    private final Object lock = new Lock();

    private UIDManager() {
        this.storage = new UIDStorage(UID_MANAGER_DEFAULT_SLICED_NUMBER, UID_MANAGER_DEFAULT_CAPACITY);
    }

    public static UIDManager instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> CsmUID<T> getSharedUID(CsmUID<T> csmUID) {
        if (csmUID == null) {
            throw new NullPointerException("null string is illegal to share");
        }
        CsmUID<T> csmUID2 = null;
        Object object = this.lock;
        synchronized (object) {
            csmUID2 = this.storage.getSharedUID(csmUID);
        }
        assert (csmUID2 != null);
        assert (csmUID2.equals(csmUID));
        return csmUID2;
    }

    public final void dispose() {
        this.storage.dispose();
    }

    static {
        int n = CndUtils.getConcurrencyLevel();
        if (n <= 4) {
            UID_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            UID_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            UID_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            UID_MANAGER_DEFAULT_CAPACITY = 128;
        }
        instance = new UIDManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UIDStorage {
        private final WeakSharedSet<CsmUID<?>>[] instances;
        private final int segmentMask;
        private final int initialCapacity;

        private UIDStorage(int n, int n2) {
            int n3;
            for (n3 = 1; n3 < n; n3 <<= 1) {
            }
            this.segmentMask = n3 - 1;
            this.initialCapacity = n2;
            WeakSharedSet[] weakSharedSetArray = new WeakSharedSet[n3];
            for (int i = 0; i < weakSharedSetArray.length; ++i) {
                weakSharedSetArray[i] = new WeakSharedSet(n2);
            }
            this.instances = weakSharedSetArray;
        }

        private WeakSharedSet<CsmUID<?>> getDelegate(CsmUID<?> csmUID) {
            int n = csmUID.hashCode() & this.segmentMask;
            return this.instances[n];
        }

        public final <T> CsmUID<T> getSharedUID(CsmUID<T> csmUID) {
            return (CsmUID)this.getDelegate(csmUID).addOrGet(csmUID);
        }

        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                if (this.instances[i].size() <= 0) continue;
                if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                    Object[] objectArray = this.instances[i].toArray();
                    System.out.println("Dispose UID cache " + this.instances[i].size());
                    HashMap<Class, Integer> hashMap = new HashMap<Class, Integer>();
                    HashMap<Class, Integer> hashMap2 = new HashMap<Class, Integer>();
                    for (Object object : objectArray) {
                        if (object == null) continue;
                        this.incCounter(hashMap, object);
                        if (!(object instanceof KeyBasedUID)) continue;
                        Key key = ((KeyBasedUID)object).getKey();
                        this.incCounter(hashMap2, key);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                    System.out.println("-----------");
                    for (Map.Entry entry : hashMap2.entrySet()) {
                        System.out.println("   " + entry.getValue() + " of " + ((Class)entry.getKey()).getName());
                    }
                }
                this.instances[i].clear();
                this.instances[i].resize(this.initialCapacity);
            }
        }

        private void incCounter(Map<Class, Integer> map, Object object) {
            Integer n = map.get(object.getClass());
            n = n != null ? Integer.valueOf(n + 1) : Integer.valueOf(1);
            map.put(object.getClass(), n);
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

