/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.upgrade.XMLStorage;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ColoringStorage {
    ColoringStorage() {
    }

    static Map loadColorings(InputStream inputStream, String string) {
        return (Map)XMLStorage.load(inputStream, string, new ColoringsReader());
    }

    static void saveColorings(FileObject fileObject, Collection collection) {
        StringBuffer stringBuffer = XMLStorage.generateHeader();
        XMLStorage.generateFolderStart(stringBuffer, "fontscolors", null, "");
        for (AttributeSet attributeSet : collection) {
            XMLStorage.Attribs attribs = new XMLStorage.Attribs(true);
            attribs.add("name", (String)attributeSet.getAttribute(StyleConstants.NameAttribute));
            if (attributeSet.isDefined(StyleConstants.Foreground)) {
                attribs.add("foreColor", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Foreground)));
            }
            if (attributeSet.isDefined(StyleConstants.Background)) {
                attribs.add("bgColor", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Background)));
            }
            if (attributeSet.isDefined(StyleConstants.StrikeThrough)) {
                attribs.add("strikeThrough", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.StrikeThrough)));
            }
            if (attributeSet.isDefined("waveUnderlined")) {
                attribs.add("waveUnderlined", XMLStorage.colorToString((Color)attributeSet.getAttribute("waveUnderlined")));
            }
            if (attributeSet.isDefined(StyleConstants.Underline)) {
                attribs.add("underline", XMLStorage.colorToString((Color)attributeSet.getAttribute(StyleConstants.Underline)));
            }
            if (attributeSet.isDefined("default")) {
                attribs.add("default", (String)attributeSet.getAttribute("default"));
            }
            if (attributeSet.isDefined(StyleConstants.FontFamily) || attributeSet.isDefined(StyleConstants.FontSize) || attributeSet.isDefined(StyleConstants.Bold) || attributeSet.isDefined(StyleConstants.Italic)) {
                XMLStorage.generateFolderStart(stringBuffer, "fontcolor", attribs, "    ");
                attribs = new XMLStorage.Attribs(true);
                if (attributeSet.isDefined(StyleConstants.FontFamily)) {
                    attribs.add("name", (String)attributeSet.getAttribute(StyleConstants.FontFamily));
                }
                if (attributeSet.isDefined(StyleConstants.FontSize)) {
                    attribs.add("size", "" + attributeSet.getAttribute(StyleConstants.FontSize));
                }
                if (attributeSet.isDefined(StyleConstants.Bold) || attributeSet.isDefined(StyleConstants.Italic)) {
                    Boolean bl = Boolean.FALSE;
                    Boolean bl2 = Boolean.FALSE;
                    if (attributeSet.isDefined(StyleConstants.Bold)) {
                        bl = (Boolean)attributeSet.getAttribute(StyleConstants.Bold);
                    }
                    if (attributeSet.isDefined(StyleConstants.Italic)) {
                        bl2 = (Boolean)attributeSet.getAttribute(StyleConstants.Italic);
                    }
                    attribs.add("style", bl.booleanValue() ? (bl2.booleanValue() ? "bold+italic" : "bold") : (bl2 != false ? "italic" : "plain"));
                }
                XMLStorage.generateLeaf(stringBuffer, "font", attribs, "        ");
                XMLStorage.generateFolderEnd(stringBuffer, "fontcolor", "    ");
                continue;
            }
            XMLStorage.generateLeaf(stringBuffer, "fontcolor", attribs, "    ");
        }
        XMLStorage.generateFolderEnd(stringBuffer, "fontscolors", "");
        XMLStorage.save(fileObject, new String(stringBuffer));
    }

    private static String getFolderName(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Editors");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('/').append(stringArray[i]);
        }
        if (string != null) {
            stringBuffer.append('/').append(string);
        }
        return stringBuffer.append('/').toString();
    }

    private static FileObject createFileObject(FileObject fileObject, String[] stringArray, String string, String string2) {
        try {
            FileObject fileObject2 = ColoringStorage.getFO(FileUtil.getConfigRoot(), "Editors");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                fileObject2 = ColoringStorage.getFO(fileObject2, stringArray[i]);
            }
            if (string != null) {
                fileObject2 = ColoringStorage.getFO(fileObject2, string);
            }
            if (string2 == null) {
                return fileObject2;
            }
            FileObject fileObject3 = fileObject2.getFileObject(string2);
            if (fileObject3 != null) {
                return fileObject3;
            }
            return fileObject2.createData(string2);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return null;
        }
    }

    private static FileObject getFO(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 == null) {
            return fileObject.createFolder(string);
        }
        return fileObject2;
    }

    private static class ColoringsReader
    extends XMLStorage.Handler {
        private Map<String, SimpleAttributeSet> colorings = new HashMap<String, SimpleAttributeSet>();
        private SimpleAttributeSet last;

        private ColoringsReader() {
        }

        Object getResult() {
            return this.colorings;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            block18: {
                try {
                    if (string3.equals("fontscolors")) break block18;
                    if (string3.equals("fontcolor")) {
                        String string4 = attributes.getValue("syntaxName");
                        if (string4 == null) {
                            string4 = attributes.getValue("name");
                        }
                        if (string4 == null) {
                            System.out.println("no syntaxName " + attributes);
                            return;
                        }
                        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                        simpleAttributeSet.addAttribute(StyleConstants.NameAttribute, string4);
                        if (attributes.getValue("bgColor") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Background, XMLStorage.stringToColor(attributes.getValue("bgColor")));
                        }
                        if (attributes.getValue("foreColor") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Foreground, XMLStorage.stringToColor(attributes.getValue("foreColor")));
                        }
                        if (attributes.getValue("underline") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.Underline, XMLStorage.stringToColor(attributes.getValue("underline")));
                        }
                        if (attributes.getValue("strikeThrough") != null) {
                            simpleAttributeSet.addAttribute(StyleConstants.StrikeThrough, XMLStorage.stringToColor(attributes.getValue("strikeThrough")));
                        }
                        if (attributes.getValue("waveUnderlined") != null) {
                            simpleAttributeSet.addAttribute("waveUnderlined", XMLStorage.stringToColor(attributes.getValue("waveUnderlined")));
                        }
                        if (attributes.getValue("default") != null) {
                            simpleAttributeSet.addAttribute("default", attributes.getValue("default"));
                        }
                        this.colorings.put(string4, simpleAttributeSet);
                        this.last = simpleAttributeSet;
                        break block18;
                    }
                    if (!string3.equals("font")) break block18;
                    if (attributes.getValue("name") != null) {
                        this.last.addAttribute(StyleConstants.FontFamily, attributes.getValue("name"));
                    }
                    if (attributes.getValue("size") != null) {
                        try {
                            this.last.addAttribute(StyleConstants.FontSize, Integer.decode(attributes.getValue("size")));
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    if (attributes.getValue("style") != null) {
                        if (attributes.getValue("style").indexOf("bold") >= 0) {
                            this.last.addAttribute(StyleConstants.Bold, Boolean.TRUE);
                        }
                        if (attributes.getValue("style").indexOf("italic") >= 0) {
                            this.last.addAttribute(StyleConstants.Italic, Boolean.TRUE);
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
        }

        public InputSource resolveEntity(String string, String string2) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }
}

