/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.threadmap.dataprovider;

import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilterFactory;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.msa.support.MSASQLTables;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.threadmap.api.ThreadData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapData;
import org.netbeans.modules.dlight.threadmap.api.ThreadMapSummaryData;
import org.netbeans.modules.dlight.threadmap.api.ThreadSummaryData;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataProvider;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapDataQuery;
import org.netbeans.modules.dlight.threadmap.spi.dataprovider.ThreadMapSummaryDataQuery;
import org.netbeans.modules.dlight.threadmap.storage.ThreadInfoImpl;
import org.netbeans.modules.dlight.threadmap.storage.ThreadStateImpl;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadMapDataProviderImpl
implements ThreadMapDataProvider {
    private static final Logger log = DLightLogger.getLogger(ThreadMapDataProviderImpl.class);
    private SQLDataStorage sqlStorage;
    private PreparedStatement queryDataStatement;
    private static final String[] summaryColNames = new String[]{"", MSASQLTables.msa.LWP_ID.getColumnName(), MSASQLTables.msa.LWP_MSA_USR.getColumnName(), MSASQLTables.msa.LWP_MSA_SYS.getColumnName(), MSASQLTables.msa.LWP_MSA_TRP.getColumnName(), MSASQLTables.msa.LWP_MSA_TFL.getColumnName(), MSASQLTables.msa.LWP_MSA_DFL.getColumnName(), MSASQLTables.msa.LWP_MSA_KFL.getColumnName(), MSASQLTables.msa.LWP_MSA_LCK.getColumnName(), MSASQLTables.msa.LWP_MSA_SLP.getColumnName(), MSASQLTables.msa.LWP_MSA_LAT.getColumnName(), MSASQLTables.msa.LWP_MSA_STP.getColumnName()};
    private PreparedStatement querySummaryStatement;
    private PreparedStatement queryLWPInfo;
    private final HashMap<Integer, ThreadInfo> ti = new HashMap();
    private ThreadDumpProvider threadDumpProvider;

    public synchronized void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        DLightSession dLightSession = DLightManager.getDefault().getActiveSession();
        StackDataProvider stackDataProvider = (StackDataProvider)dLightSession.createDataProvider(DataModelSchemeProvider.getInstance().getScheme("model:threaddump"), null);
        if (stackDataProvider != null) {
            this.threadDumpProvider = stackDataProvider.getThreadDumpProvider();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ThreadMapData queryData(ThreadMapDataQuery threadMapDataQuery) {
        Object object;
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("DataQuery: [%d, %d], fullstate: %s", threadMapDataQuery.getTimeFrom(), threadMapDataQuery.getTimeTo(), threadMapDataQuery.isFullState() ? "yes" : "no"));
        }
        if (this.sqlStorage == null) {
            throw new NullPointerException("No STORAGE");
        }
        final ArrayList<1> arrayList = new ArrayList<1>();
        HashMap hashMap = new HashMap();
        try {
            this.queryDataStatement.setLong(1, threadMapDataQuery.getTimeFrom());
            this.queryDataStatement.setLong(2, threadMapDataQuery.getTimeTo());
            object = this.queryDataStatement.executeQuery();
            try {
                while (object.next()) {
                    List<ThreadStateImpl> list;
                    ThreadInfo threadInfo;
                    int n = object.getInt(MSASQLTables.lwps.LWP_ID.getColumnName());
                    if (this.ti.containsKey(n)) {
                        threadInfo = this.ti.get(n);
                    } else {
                        threadInfo = this.getLWPInfo(n);
                        this.ti.put(n, threadInfo);
                    }
                    if (hashMap.containsKey(n)) {
                        list = (List)hashMap.get(n);
                    } else {
                        list = new ArrayList();
                        hashMap.put(n, list);
                        arrayList.add(new ThreadData(){

                            @Override
                            public ThreadInfo getThreadInfo() {
                                return threadInfo;
                            }

                            @Override
                            public List<ThreadState> getThreadState() {
                                return list;
                            }
                        });
                    }
                    long l = object.getLong(MSASQLTables.msa.TIMESTAMP.getColumnName());
                    long l2 = object.getLong(MSASQLTables.msa.SAMPLE.getColumnName());
                    long[] lArray = new long[]{1L, 0L, 0L, object.getLong(MSASQLTables.msa.LWP_MSA_USR.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_SYS.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_TRP.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_TFL.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_DFL.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_KFL.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_LAT.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_STP.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_LCK.getColumnName()), object.getLong(MSASQLTables.msa.LWP_MSA_SLP.getColumnName())};
                    ThreadStateImpl threadStateImpl = new ThreadStateImpl(l, l2, lArray);
                    list.add(threadStateImpl);
                }
            }
            finally {
                object.close();
            }
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, null, sQLException);
        }
        object = new ThreadMapData(){

            @Override
            public List<ThreadData> getThreadsData() {
                return arrayList;
            }

            @Override
            public boolean isSamplingMode() {
                return false;
            }
        };
        return object;
    }

    @Override
    public synchronized ThreadDump getThreadDump(ThreadDumpQuery threadDumpQuery) {
        return this.threadDumpProvider == null ? null : this.threadDumpProvider.getThreadDump(threadDumpQuery);
    }

    @Override
    public Collection<ThreadSnapshot> getThreadSnapshots(ThreadSnapshotQuery threadSnapshotQuery) {
        return this.threadDumpProvider == null ? null : this.threadDumpProvider.getThreadSnapshots(threadSnapshotQuery);
    }

    public synchronized void attachTo(DataStorage dataStorage) {
        if (dataStorage instanceof SQLDataStorage) {
            this.sqlStorage = (SQLDataStorage)dataStorage;
            String string = String.format("select %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s from %s where %s >= ? and %s < ?", MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.SAMPLE.getColumnName(), MSASQLTables.msa.LWP_ID.getColumnName(), MSASQLTables.msa.LWP_MSA_USR.getColumnName(), MSASQLTables.msa.LWP_MSA_SYS.getColumnName(), MSASQLTables.msa.LWP_MSA_TRP.getColumnName(), MSASQLTables.msa.LWP_MSA_TFL.getColumnName(), MSASQLTables.msa.LWP_MSA_DFL.getColumnName(), MSASQLTables.msa.LWP_MSA_KFL.getColumnName(), MSASQLTables.msa.LWP_MSA_LCK.getColumnName(), MSASQLTables.msa.LWP_MSA_SLP.getColumnName(), MSASQLTables.msa.LWP_MSA_LAT.getColumnName(), MSASQLTables.msa.LWP_MSA_STP.getColumnName(), MSASQLTables.msa.tableMetadata.getName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.TIMESTAMP.getColumnName());
            try {
                this.queryDataStatement = this.sqlStorage.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                log.log(Level.SEVERE, null, sQLException);
            }
            string = String.format("select %s, sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s), sum(%s) from %s where %s >= ? and %s < ? group by %s", summaryColNames[1], summaryColNames[2], summaryColNames[3], summaryColNames[4], summaryColNames[5], summaryColNames[6], summaryColNames[7], summaryColNames[8], summaryColNames[9], summaryColNames[10], summaryColNames[11], MSASQLTables.msa.tableMetadata.getName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.TIMESTAMP.getColumnName(), MSASQLTables.msa.LWP_ID.getColumnName());
            try {
                this.querySummaryStatement = this.sqlStorage.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                log.log(Level.SEVERE, null, sQLException);
            }
            string = String.format("select %s from %s where %s = ?", MSASQLTables.lwps.LWP_START.getColumnName(), MSASQLTables.lwps.tableMetadata.getName(), MSASQLTables.lwps.LWP_ID.getColumnName());
            try {
                this.queryLWPInfo = this.sqlStorage.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                log.log(Level.SEVERE, null, sQLException);
            }
            this.ti.clear();
        }
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ThreadInfo getLWPInfo(int n) {
        ThreadInfoImpl threadInfoImpl = null;
        try {
            this.queryLWPInfo.setInt(1, n);
            ResultSet resultSet = this.queryLWPInfo.executeQuery();
            try {
                if (resultSet.next()) {
                    long l = resultSet.getLong(1);
                    threadInfoImpl = new ThreadInfoImpl(n, "Thread " + n, l);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, null, sQLException);
        }
        return threadInfoImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ThreadMapSummaryData queryData(ThreadMapSummaryDataQuery threadMapSummaryDataQuery) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("DataQuery: [%s], fullstate: %s", Arrays.toString(threadMapSummaryDataQuery.getIntervals().toArray()), threadMapSummaryDataQuery.isFullState() ? "yes" : "no"));
        }
        if (this.sqlStorage == null) {
            throw new NullPointerException("No STORAGE");
        }
        Collection<TimeIntervalDataFilter> collection = threadMapSummaryDataQuery.getIntervals();
        if (collection.isEmpty()) {
            collection = new ArrayList<TimeIntervalDataFilter>(1);
            collection.add(TimeIntervalDataFilterFactory.create((Range)new Range((Number)0L, (Number)Long.MAX_VALUE)));
        }
        final ArrayList<4> arrayList = new ArrayList<4>();
        Range range = collection.iterator().next().getInterval();
        try {
            this.querySummaryStatement.setLong(1, (Long)range.getStart());
            this.querySummaryStatement.setLong(2, (Long)range.getEnd());
            ResultSet resultSet = this.querySummaryStatement.executeQuery();
            try {
                while (resultSet.next()) {
                    int n = resultSet.getInt(MSASQLTables.lwps.LWP_ID.getColumnName());
                    final ThreadInfo threadInfo = this.getLWPInfo(n);
                    if (threadInfo == null) continue;
                    final ArrayList<3> arrayList2 = new ArrayList<3>();
                    for (int i = 2; i < 12; ++i) {
                        final long l = resultSet.getLong(i);
                        if (l <= 0L) continue;
                        final ThreadState.MSAState mSAState = ThreadState.MSAState.fromCode((int)(i - 2), (boolean)threadMapSummaryDataQuery.isFullState());
                        arrayList2.add(new ThreadSummaryData.StateDuration(){

                            public ThreadState.MSAState getState() {
                                return mSAState;
                            }

                            public long getDuration() {
                                return l;
                            }

                            public String toString() {
                                return String.format("%s: %dns", mSAState.toString(), l);
                            }
                        });
                    }
                    arrayList.add(new ThreadSummaryData(){

                        @Override
                        public ThreadInfo getThreadInfo() {
                            return threadInfo;
                        }

                        @Override
                        public List<ThreadSummaryData.StateDuration> getThreadSummary() {
                            return arrayList2;
                        }
                    });
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            log.log(Level.SEVERE, null, sQLException);
        }
        return new ThreadMapSummaryData(){

            @Override
            public List<ThreadSummaryData> getThreadsData() {
                return arrayList;
            }
        };
    }

    @Override
    public List<ThreadMapDataProvider.ThreadNameDetails> getThreadNameDetails(final int n) {
        ArrayList<ThreadMapDataProvider.ThreadNameDetails> arrayList = new ArrayList<ThreadMapDataProvider.ThreadNameDetails>();
        arrayList.add(new ThreadMapDataProvider.ThreadNameDetails(){

            public String getName() {
                return "Thread" + n;
            }

            public Action goToSource() {
                return new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                    }
                };
            }
        });
        return arrayList;
    }
}

