/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.php.editor.options.MarkOccurencesOptionsPanelController;
import org.netbeans.modules.php.editor.options.MarkOccurencesSettings;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MarkOccurencesPanel
extends JPanel {
    private static final boolean DEFAULT_VALUE = true;
    private List<JCheckBox> boxes;
    private MarkOccurencesOptionsPanelController controller;
    private JCheckBox onOffCheckBox;

    public MarkOccurencesPanel(MarkOccurencesOptionsPanelController markOccurencesOptionsPanelController) {
        this.initComponents();
        this.fillBoxes();
        this.addListeners();
        this.load(markOccurencesOptionsPanelController);
    }

    public void load(MarkOccurencesOptionsPanelController markOccurencesOptionsPanelController) {
        this.controller = markOccurencesOptionsPanelController;
        Preferences preferences = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox jCheckBox : this.boxes) {
            jCheckBox.setSelected(preferences.getBoolean(jCheckBox.getActionCommand(), true));
        }
        this.componentsSetEnabled();
    }

    public void store() {
        Preferences preferences = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox jCheckBox : this.boxes) {
            boolean bl;
            boolean bl2 = jCheckBox.isSelected();
            if (bl2 == (bl = preferences.getBoolean(jCheckBox.getActionCommand(), true))) continue;
            preferences.putBoolean(jCheckBox.getActionCommand(), bl2);
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    public boolean changed() {
        Preferences preferences = MarkOccurencesSettings.getCurrentNode();
        for (JCheckBox jCheckBox : this.boxes) {
            boolean bl;
            boolean bl2 = jCheckBox.isSelected();
            if (bl2 == (bl = preferences.getBoolean(jCheckBox.getActionCommand(), true))) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.onOffCheckBox = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            public Component getFirstComponent(Container container) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            public Component getLastComponent(Container container) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            public Component getComponentAfter(Container container, Component component) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }

            public Component getComponentBefore(Container container, Component component) {
                return MarkOccurencesPanel.this.onOffCheckBox;
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.onOffCheckBox, (String)NbBundle.getMessage(MarkOccurencesPanel.class, (String)"CTL_OnOff_CheckBox"));
        this.onOffCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.onOffCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.onOffCheckBox.setOpaque(false);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.onOffCheckBox).addContainerGap(226, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.onOffCheckBox).addContainerGap(273, Short.MAX_VALUE)));
        this.onOffCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurencesPanel.onOffCheckBox.AccessibleContext.accessibleName"));
        this.onOffCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"ACSD_OnOff_CB"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurencesPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarkOccurencesPanel.class, (String)"MarkOccurencesPanel.AccessibleContext.accessibleDescription"));
    }

    private void fillBoxes() {
        this.boxes = new ArrayList<JCheckBox>();
        this.boxes.add(this.onOffCheckBox);
        this.onOffCheckBox.setActionCommand(MarkOccurencesSettings.ON_OFF);
    }

    private void addListeners() {
        CheckChangeListener checkChangeListener = new CheckChangeListener();
        for (JCheckBox jCheckBox : this.boxes) {
            jCheckBox.addChangeListener(checkChangeListener);
        }
    }

    private void componentsSetEnabled() {
        for (int i = 1; i < this.boxes.size(); ++i) {
            this.boxes.get(i).setEnabled(this.onOffCheckBox.isSelected());
        }
    }

    private class CheckChangeListener
    implements ChangeListener {
        private CheckChangeListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == MarkOccurencesPanel.this.onOffCheckBox) {
                MarkOccurencesPanel.this.componentsSetEnabled();
            }
            MarkOccurencesPanel.this.controller.changed();
        }
    }
}

