/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.IndexSearcher;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.PHPCompletionItem;
import org.netbeans.modules.php.editor.index.IndexedConstant;
import org.netbeans.modules.php.editor.index.IndexedElement;
import org.netbeans.modules.php.editor.index.IndexedFullyQualified;
import org.netbeans.modules.php.editor.index.IndexedFunction;
import org.netbeans.modules.php.editor.index.IndexedInterface;
import org.netbeans.modules.php.editor.index.IndexedType;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.QualifiedNameKind;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPTypeSearcher
implements IndexSearcher {
    public Set<? extends IndexSearcher.Descriptor> getSymbols(Project project, String string, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        Object object;
        EnumSet<QuerySupport.Kind> enumSet = EnumSet.of(QuerySupport.Kind.CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP);
        if ((kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.PREFIX) && PHPTypeSearcher.isCamelCasePattern(string)) {
            kind = QuerySupport.Kind.CAMEL_CASE;
        }
        PHPIndex pHPIndex = PHPIndex.get(QuerySupport.findRoots((Project)project, Collections.singleton("classpath/php-source"), Collections.singleton("classpath/php-boot"), Collections.emptySet()));
        HashSet<PHPTypeDescriptor> hashSet = new HashSet<PHPTypeDescriptor>();
        if (pHPIndex != null && string.trim().length() > 0) {
            QuerySupport.Kind kind2;
            boolean bl = string.startsWith("$");
            object = this.prepareIdxQuery(string, enumSet, kind);
            QuerySupport.Kind kind3 = kind2 = kind.equals((Object)QuerySupport.Kind.EXACT) ? QuerySupport.Kind.EXACT : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
            if (!kind.equals((Object)QuerySupport.Kind.EXACT)) {
                object = ((String)object).toLowerCase();
            }
            if (!bl) {
                for (IndexedElement indexedElement : pHPIndex.getAllTopLevel(null, (String)object, kind2)) {
                    hashSet.add(new PHPTypeDescriptor(indexedElement, helper));
                }
                for (IndexedFunction indexedFunction : pHPIndex.getMethods(null, (String)null, (String)object, kind2, -1)) {
                    hashSet.add(new PHPTypeDescriptor(indexedFunction, helper));
                }
            }
            for (IndexedElement indexedElement : PHPTypeSearcher.getTopLevelVariables(pHPIndex, (String)(bl ? object : PHPTypeSearcher.appendDollar((String)object)), kind2)) {
                hashSet.add(new PHPTypeDescriptor(indexedElement, helper));
            }
            for (IndexedConstant indexedConstant : pHPIndex.getFields(null, (String)null, (String)(bl ? PHPTypeSearcher.stripDollar((String)object) : object), kind2, -1)) {
                hashSet.add(new PHPTypeDescriptor(indexedConstant, helper));
            }
            for (IndexedConstant indexedConstant : pHPIndex.getTypeConstants(null, (String)null, (String)object, kind2)) {
                hashSet.add(new PHPTypeDescriptor(indexedConstant, helper));
            }
        }
        if (enumSet.contains(kind)) {
            HashSet<PHPTypeDescriptor> hashSet2 = hashSet;
            hashSet = new HashSet();
            object = PHPTypeSearcher.queryToPattern(string);
            for (PHPTypeDescriptor pHPTypeDescriptor : hashSet2) {
                String string2 = pHPTypeDescriptor.getElement().getName();
                if (!((Pattern)object).matcher(string2).matches()) continue;
                hashSet.add(pHPTypeDescriptor);
            }
        }
        return hashSet;
    }

    public Set<? extends IndexSearcher.Descriptor> getTypes(Project project, String string, QuerySupport.Kind kind, IndexSearcher.Helper helper) {
        Collection collection;
        Collection<IndexedElement> collection2;
        Object object;
        EnumSet<QuerySupport.Kind> enumSet = EnumSet.of(QuerySupport.Kind.CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE, QuerySupport.Kind.CASE_INSENSITIVE_REGEXP);
        if ((kind == QuerySupport.Kind.CASE_INSENSITIVE_PREFIX || kind == QuerySupport.Kind.PREFIX) && PHPTypeSearcher.isCamelCasePattern(string)) {
            kind = QuerySupport.Kind.CAMEL_CASE;
        }
        PHPIndex pHPIndex = PHPIndex.get(QuerySupport.findRoots((Project)project, Collections.singleton("classpath/php-source"), Collections.singleton("classpath/php-boot"), Collections.emptySet()));
        HashSet<Object> hashSet = new HashSet<Object>();
        NamespaceIndexFilter<IndexedElement> namespaceIndexFilter = new NamespaceIndexFilter<IndexedElement>(string);
        QualifiedNameKind qualifiedNameKind = namespaceIndexFilter.getKind();
        if (pHPIndex != null) {
            object = qualifiedNameKind.isUnqualified() ? this.prepareIdxQuery(string, enumSet, kind).toLowerCase() : namespaceIndexFilter.getName();
            collection2 = PHPTypeSearcher.getClasses(pHPIndex, (String)object, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
            if (!qualifiedNameKind.isUnqualified()) {
                collection2 = namespaceIndexFilter.filter(collection2);
            }
            for (Object object2 : collection2) {
                hashSet.add((Object)new PHPTypeDescriptor((IndexedElement)object2, helper));
            }
            collection = PHPTypeSearcher.getInterfaces(pHPIndex, (String)object, QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
            if (!qualifiedNameKind.isUnqualified()) {
                collection = namespaceIndexFilter.filter(collection);
            }
            for (Object object3 : collection) {
                hashSet.add((Object)new PHPTypeDescriptor((IndexedElement)object3, helper));
            }
        }
        if (qualifiedNameKind.isUnqualified() && enumSet.contains(kind)) {
            object = hashSet;
            hashSet = new HashSet();
            collection2 = PHPTypeSearcher.queryToPattern(string);
            collection = object.iterator();
            while (collection.hasNext()) {
                Object object3;
                Object object2;
                object2 = (PHPTypeDescriptor)((Object)collection.next());
                object3 = ((PHPTypeDescriptor)((Object)object2)).getElement().getName();
                if (!((Pattern)((Object)collection2)).matcher((CharSequence)object3).matches()) continue;
                hashSet.add(object2);
            }
        }
        return hashSet;
    }

    private static Collection<IndexedElement> getTopLevelVariables(PHPIndex pHPIndex, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedElement> arrayList = new ArrayList<IndexedElement>();
        arrayList.addAll(pHPIndex.getTopLevelVariables(null, string, kind));
        return arrayList;
    }

    private static Collection<IndexedElement> getClasses(PHPIndex pHPIndex, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedElement> arrayList = new ArrayList<IndexedElement>();
        arrayList.addAll(pHPIndex.getClasses(null, string, kind));
        return arrayList;
    }

    private static Collection<IndexedElement> getInterfaces(PHPIndex pHPIndex, String string, QuerySupport.Kind kind) {
        ArrayList<IndexedElement> arrayList = new ArrayList<IndexedElement>();
        arrayList.addAll(pHPIndex.getInterfaces(null, string, kind));
        return arrayList;
    }

    private static String stripDollar(String string) {
        if (string.startsWith("$")) {
            return string.substring(1);
        }
        return string;
    }

    private static String appendDollar(String string) {
        if (!string.startsWith("$")) {
            return "$" + string;
        }
        return string;
    }

    private static Pattern queryToPattern(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        if (!string.startsWith("$")) {
            stringBuilder.append("[$]*");
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '?') {
                stringBuilder.append('.');
                continue;
            }
            if (cArray[i] == '*') {
                stringBuilder.append(".*");
                continue;
            }
            if (Character.isUpperCase(cArray[i])) {
                if (bl) {
                    stringBuilder.append("[a-z0-9_]*");
                }
                stringBuilder.append(cArray[i]);
                bl = true;
                continue;
            }
            if (i == 0 && cArray[i] == '$') {
                stringBuilder.append('\\').append(cArray[i]);
                continue;
            }
            stringBuilder.append(cArray[i]);
        }
        stringBuilder.append(".*");
        String string2 = stringBuilder.toString();
        string2 = string2.replaceAll(Pattern.quote(".."), ".");
        return Pattern.compile(string2);
    }

    private String prepareIdxQuery(String string, EnumSet<QuerySupport.Kind> enumSet, QuerySupport.Kind kind) {
        String string2 = string.toLowerCase();
        if (enumSet.contains(kind)) {
            char c = string.charAt(0);
            int n = string.length();
            string2 = Character.isLetter(c) && n > 0 ? string2.substring(0, 1) : (c == '$' && n > 1 ? string2.substring(0, 1) : "");
        }
        return string2;
    }

    private static boolean isCamelCasePattern(String string) {
        char[] cArray;
        for (char c : cArray = string.toCharArray()) {
            if (c != '*' && c != '?' && !Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    private static class PHPTypeDescriptor
    extends IndexSearcher.Descriptor {
        private final IndexedElement element;
        private final IndexedElement enclosingClass;
        private String projectName;
        private Icon projectIcon;
        private final IndexSearcher.Helper helper;

        public PHPTypeDescriptor(IndexedElement indexedElement, IndexSearcher.Helper helper) {
            this(indexedElement, null, helper);
        }

        public PHPTypeDescriptor(IndexedElement indexedElement, IndexedElement indexedElement2, IndexSearcher.Helper helper) {
            this.element = indexedElement;
            this.enclosingClass = indexedElement2;
            this.helper = helper;
        }

        public Icon getIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            if (this.element instanceof IndexedInterface) {
                return PHPCompletionItem.getInterfaceIcon();
            }
            return this.helper.getIcon((ElementHandle)this.element);
        }

        public String getTypeName() {
            return this.element.getName();
        }

        public String getProjectName() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        private void initProjectInfo() {
            Project project;
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                this.projectName = projectInformation.getDisplayName();
                this.projectIcon = projectInformation.getIcon();
            }
            if (this.projectName == null) {
                this.projectName = "";
            }
        }

        public Icon getProjectIcon() {
            if (this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        public FileObject getFileObject() {
            return this.element.getFileObject();
        }

        public void open() {
            FileObject fileObject = this.element.getFileObject();
            if (fileObject != null) {
                GsfUtilities.open((FileObject)fileObject, (int)this.element.getOffset(), (String)this.element.getName());
            } else {
                Logger logger = Logger.getLogger(PHPTypeSearcher.class.getName());
                logger.log(Level.INFO, String.format("%s: cannot find %s", PHPTypeSearcher.class.getName(), this.element.getFilenameUrl()));
            }
        }

        public String getContextName() {
            IndexedFullyQualified indexedFullyQualified;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.element instanceof IndexedFullyQualified) {
                indexedFullyQualified = (IndexedFullyQualified)this.element;
                if (!"".equals(indexedFullyQualified.getNamespaceName())) {
                    if (this.element instanceof IndexedType) {
                        stringBuilder.append(indexedFullyQualified.getFullyQualifiedName());
                    } else {
                        stringBuilder.append(indexedFullyQualified.getNamespaceName());
                    }
                    bl = true;
                }
            } else if (this.enclosingClass != null) {
                if (this.enclosingClass instanceof IndexedFullyQualified && !"".equals(((IndexedFullyQualified)this.enclosingClass).getNamespaceName())) {
                    stringBuilder.append(((IndexedFullyQualified)this.enclosingClass).getFullyQualifiedName());
                } else {
                    stringBuilder.append(this.enclosingClass.getName());
                }
                bl = true;
            }
            indexedFullyQualified = this.getFileObject();
            if (indexedFullyQualified != null) {
                if (bl) {
                    stringBuilder.append(" in ");
                }
                stringBuilder.append(FileUtil.getFileDisplayName((FileObject)indexedFullyQualified));
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return null;
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public int getOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getSimpleName() {
            return this.element.getName();
        }

        public String getOuterName() {
            return null;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            PHPTypeDescriptor pHPTypeDescriptor = (PHPTypeDescriptor)((Object)object);
            return this.element == pHPTypeDescriptor.element || this.element != null && this.element.equals(pHPTypeDescriptor.element);
        }

        public int hashCode() {
            int n = 7;
            n = 19 * n + (this.element != null ? this.element.hashCode() : 0);
            return n;
        }
    }
}

