/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.ui.GemNode;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GemChildrenFactory
extends ChildFactory<FileObject> {
    private final RubyPlatform platform;
    private static final String GEMS_DIR = "gems";
    private static final FileFilter DIRS = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static final Comparator<FileObject> NAME_COMPARATOR = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            return fileObject.getNameExt().compareToIgnoreCase(fileObject2.getNameExt());
        }
    };
    private final FileChangeListener fileListener = new FileChangeListener(){

        public void fileFolderCreated(FileEvent fileEvent) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileChanged(FileEvent fileEvent) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileDeleted(FileEvent fileEvent) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            GemChildrenFactory.this.refresh(false);
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            GemChildrenFactory.this.refresh(false);
        }
    };

    public static GemChildrenFactory create(RubyBaseProject rubyBaseProject) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)rubyBaseProject);
        GemChildrenFactory gemChildrenFactory = new GemChildrenFactory(rubyPlatform);
        return gemChildrenFactory;
    }

    private GemChildrenFactory(RubyPlatform rubyPlatform) {
        this.platform = rubyPlatform;
    }

    protected Node createNodeForKey(FileObject fileObject) {
        return new GemNode(fileObject);
    }

    protected boolean createKeys(List<FileObject> list) {
        GemManager gemManager = this.platform.getGemManager();
        if (gemManager == null) {
            return true;
        }
        for (File file : gemManager.getRepositories()) {
            File file2 = new File(file, GEMS_DIR);
            if (!file2.exists() || !file2.isDirectory()) continue;
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this.fileListener, (File)file2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (File file3 : file2.listFiles(DIRS)) {
                list.add(FileUtil.toFileObject((File)file3));
            }
        }
        Collections.sort(list, NAME_COMPARATOR);
        return true;
    }
}

