/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.modules.ruby.rubyproject.RubyLoggingOptionsPanel;
import org.netbeans.modules.ruby.rubyproject.RubyLoggingSettings;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RubyLoggingOption
extends AdvancedOption {
    private static final Logger RUBY_LOGGER = Logger.getLogger("org.netbeans.modules.ruby");
    private static final Logger YAML_LOGGER = Logger.getLogger("org.netbeans.modules.languages.yaml");
    private static final Logger EXECUTION_LOGGER = Logger.getLogger("org.netbeans.api.extexecution");
    private static final Logger DEBUGGER_LOGGER = Logger.getLogger("org.rubyforge.debugcommons");

    public String getDisplayName() {
        return NbBundle.getMessage(RubyLoggingOption.class, (String)"RubyLoggingOption.displayName.text");
    }

    public String getTooltip() {
        return this.getDisplayName();
    }

    public OptionsPanelController create() {
        return new Controller();
    }

    static void initLoggers() {
        RubyLoggingOption.setIfHigher(RUBY_LOGGER, RubyLoggingSettings.getDefault().getLoggingLevel(RUBY_LOGGER));
        RubyLoggingOption.setIfHigher(YAML_LOGGER, RubyLoggingSettings.getDefault().getLoggingLevel(YAML_LOGGER));
        RubyLoggingOption.setIfHigher(EXECUTION_LOGGER, RubyLoggingSettings.getDefault().getLoggingLevel(EXECUTION_LOGGER));
        RubyLoggingOption.setIfHigher(DEBUGGER_LOGGER, RubyLoggingSettings.getDefault().getLoggingLevel(DEBUGGER_LOGGER));
    }

    private static void setIfHigher(Logger logger, Level level) {
        if (level == null) {
            return;
        }
        if (logger.getLevel() == null || level.intValue() < logger.getLevel().intValue()) {
            logger.setLevel(level);
        }
    }

    private static final class Controller
    extends OptionsPanelController {
        private final RubyLoggingOptionsPanel component = new RubyLoggingOptionsPanel();

        private Controller() {
        }

        public void update() {
            Level level = DEBUGGER_LOGGER.getLevel();
            Level level2 = RUBY_LOGGER.getLevel();
            boolean bl = level != null && level.intValue() <= Level.FINEST.intValue();
            this.component.setDebuggerLogging(bl);
            bl = level2 != null && level2.intValue() <= Level.FINE.intValue();
            this.component.setStandardLogging(bl);
        }

        public void applyChanges() {
            this.setLevel(RUBY_LOGGER, Level.FINE, this.component.isStandardLoggingEnabled());
            this.setLevel(YAML_LOGGER, Level.FINE, this.component.isStandardLoggingEnabled());
            this.setLevel(EXECUTION_LOGGER, Level.FINE, this.component.isStandardLoggingEnabled());
            this.setLevel(DEBUGGER_LOGGER, Level.FINEST, this.component.isDebuggerLoggingEnabled());
        }

        public void cancel() {
        }

        public boolean isValid() {
            return true;
        }

        public boolean isChanged() {
            return false;
        }

        public JComponent getComponent(Lookup lookup) {
            return this.component;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(RubyLoggingOption.class);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        private void setLevel(Logger logger, Level level, boolean bl) {
            RubyLoggingSettings rubyLoggingSettings = RubyLoggingSettings.getDefault();
            if (bl) {
                Level level2 = logger.getLevel();
                if (level2 == null || level2.intValue() > level.intValue()) {
                    logger.setLevel(level);
                    rubyLoggingSettings.setLoggingLevel(logger, level);
                }
            } else {
                logger.setLevel(null);
                rubyLoggingSettings.setLoggingLevel(logger, null);
            }
        }
    }
}

