/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.java.nodes;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.selector.java.nodes.JavacUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ConstructorsNode;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConstructorNode
extends ConstructorNode {
    private ExecutableElement method;
    private ClientUtils.SourceCodeSelection signature;
    private Set<String> modifiers;

    public JavaConstructorNode(ClasspathInfo classpathInfo, final ExecutableElement executableElement, String string, ConstructorsNode constructorsNode) {
        super(string, constructorsNode);
        this.method = executableElement;
        final String[] stringArray = new String[1];
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    stringArray[0] = JavacUtils.getVMMethodSignature(executableElement, (CompilationInfo)compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (stringArray[0] != null) {
            this.signature = new ClientUtils.SourceCodeSelection(this.getEnclosingClass(executableElement).getQualifiedName().toString(), executableElement.getSimpleName().toString(), stringArray[0]);
            this.modifiers = new HashSet<String>();
            for (Modifier modifier : executableElement.getModifiers()) {
                this.modifiers.add(modifier.name());
            }
        }
    }

    protected Set<String> getModifiers() {
        return this.modifiers;
    }

    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    private TypeElement getEnclosingClass(Element element) {
        Element element2 = element.getEnclosingElement();
        if (element2 != null) {
            if (element2.getKind() == ElementKind.CLASS || element2.getKind() == ElementKind.ENUM) {
                return (TypeElement)element2;
            }
            return this.getEnclosingClass(element2);
        }
        return null;
    }
}

