/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.IssuePanel;
import org.netbeans.modules.bugzilla.repository.BugzillaConfiguration;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ResolveIssuePanel
extends JPanel {
    private final BugzillaIssue issue;
    private JButton ok = new JButton();
    private JLabel commentLabel;
    private JButton duplicateButton;
    private JTextField duplicateField;
    private JLabel duplicateLabel;
    private JPanel duplicatePanel;
    private JComboBox resolutionCombo;
    private JLabel resolutionLabel;
    private JScrollPane scrollPane;
    private JTextArea textArea;

    public ResolveIssuePanel(BugzillaIssue bugzillaIssue) {
        this.issue = bugzillaIssue;
        this.initComponents();
        ((GroupLayout)this.getLayout()).setHonorsVisibility(false);
        BugzillaRepository bugzillaRepository = bugzillaIssue.getBugzillaRepository();
        BugzillaConfiguration bugzillaConfiguration = bugzillaRepository.getConfiguration();
        if (bugzillaConfiguration == null || !bugzillaConfiguration.isValid()) {
            return;
        }
        LinkedList<String> linkedList = new LinkedList<String>(bugzillaConfiguration.getResolutions());
        linkedList.remove("MOVED");
        this.duplicatePanel.setVisible(false);
        this.resolutionCombo.setModel(new DefaultComboBoxModel<Object>(linkedList.toArray()));
        Mnemonics.setLocalizedText((AbstractButton)this.ok, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.resolveButton"));
    }

    public String getSelectedResolution() {
        return (String)this.resolutionCombo.getSelectedItem();
    }

    public String getComment() {
        return this.textArea.getText();
    }

    private void initComponents() {
        this.resolutionLabel = new JLabel();
        this.resolutionCombo = new JComboBox();
        this.commentLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.duplicatePanel = new JPanel();
        this.duplicateLabel = new JLabel();
        this.duplicateField = new JTextField();
        this.duplicateButton = new JButton();
        this.resolutionLabel.setLabelFor(this.resolutionCombo);
        Mnemonics.setLocalizedText((JLabel)this.resolutionLabel, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.resolutionLabel.text"));
        this.commentLabel.setLabelFor(this.textArea);
        Mnemonics.setLocalizedText((JLabel)this.commentLabel, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.commentLabel.text"));
        this.textArea.setColumns(80);
        this.textArea.setRows(5);
        this.scrollPane.setViewportView(this.textArea);
        this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.textArea.AccessibleContext.accessibleDescription"));
        this.duplicateLabel.setLabelFor(this.duplicateField);
        Mnemonics.setLocalizedText((JLabel)this.duplicateLabel, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateLabel.text"));
        this.duplicateField.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.duplicateButton, (String)NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateButton.text"));
        this.duplicateButton.setFocusPainted(false);
        this.duplicateButton.setMargin(new Insets(0, 0, 0, 0));
        this.duplicateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResolveIssuePanel.this.duplicateButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.duplicatePanel);
        this.duplicatePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.duplicateLabel).addPreferredGap(0).add((Component)this.duplicateField, -2, 151, -2).addPreferredGap(0).add((Component)this.duplicateButton)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.duplicateLabel).add((Component)this.duplicateButton).add((Component)this.duplicateField, -2, -1, -2)));
        this.duplicateField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateField.AccessibleContext.accessibleDescription"));
        this.duplicateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.duplicateButton.AccessibleContext.accessibleDescription"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.resolutionLabel).add((Component)this.commentLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.resolutionCombo, -2, -1, -2).addPreferredGap(1).add((Component)this.duplicatePanel, -2, -1, -2)).add((Component)this.scrollPane)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.resolutionLabel).add((Component)this.resolutionCombo, -2, -1, -2)).add((Component)this.duplicatePanel, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.commentLabel).add((Component)this.scrollPane)).addContainerGap()));
        this.resolutionCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResolveIssuePanel.class, (String)"ResolveIssuePanel.resolutionCombo.AccessibleContext.accessibleDescription"));
    }

    private void duplicateButtonActionPerformed(ActionEvent actionEvent) {
        Issue issue = BugtrackingUtil.selectIssue((String)NbBundle.getMessage(IssuePanel.class, (String)"IssuePanel.duplicateButton.message"), (Repository)this.issue.getBugzillaRepository(), (JPanel)this, (HelpCtx)new HelpCtx("org.netbeans.modules.bugzilla.duplicateChooser"));
        if (issue != null) {
            this.duplicateField.setText(issue.getID());
        }
    }

    private void checkDuplicateId() {
        this.ok.setEnabled(!"DUPLICATE".equals(this.resolutionCombo.getSelectedItem()) || this.duplicateField.getText().trim().length() > 0);
    }

    private void resolutionComboSelectionChanged() {
        boolean bl = "DUPLICATE".equals(this.resolutionCombo.getSelectedItem());
        this.duplicatePanel.setVisible(bl);
        this.checkDuplicateId();
    }

    boolean showDialog() {
        this.ok.getAccessibleContext().setAccessibleDescription(this.ok.getText());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(ResolveIssuePanel.class, (String)"BugzillaIssueProvider.resolveIssueButton.text"), true, new Object[]{this.ok, DialogDescriptor.CANCEL_OPTION}, (Object)this.ok, 0, new HelpCtx(ResolveIssuePanel.class), null);
        this.duplicateField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                ResolveIssuePanel.this.checkDuplicateId();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                ResolveIssuePanel.this.checkDuplicateId();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                ResolveIssuePanel.this.checkDuplicateId();
            }
        });
        this.resolutionCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResolveIssuePanel.this.resolutionComboSelectionChanged();
            }
        });
        this.resolutionComboSelectionChanged();
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == this.ok;
    }

    String getDuplicateId() {
        return this.duplicateField.getText().trim();
    }
}

