/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.extensions.PermanentNodeHook;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class HookInstanciationMethod {
    private boolean isSingleton;
    private DestinationNodesGetter getter;
    private final boolean isPermanent;
    private final boolean isUndoable;
    public static final HookInstanciationMethod Once = new HookInstanciationMethod(true, true, new DefaultDestinationNodesGetter(), true);
    public static final HookInstanciationMethod OnceForRoot = new HookInstanciationMethod(true, true, new RootDestinationNodesGetter(), true);
    public static final HookInstanciationMethod OnceForAllNodes = new HookInstanciationMethod(true, true, new AllDestinationNodesGetter(), true);
    public static final HookInstanciationMethod Other = new HookInstanciationMethod(false, false, new DefaultDestinationNodesGetter(), false);
    public static final HookInstanciationMethod ApplyToRoot = new HookInstanciationMethod(false, false, new RootDestinationNodesGetter(), false);

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isPermanent() {
        return this.isPermanent;
    }

    private HookInstanciationMethod(boolean isPermanent, boolean isSingleton, DestinationNodesGetter getter, boolean isUndoable) {
        this.isPermanent = isPermanent;
        this.isSingleton = isSingleton;
        this.getter = getter;
        this.isUndoable = isUndoable;
    }

    public static final HashMap getAllInstanciationMethods() {
        HashMap<String, HookInstanciationMethod> res = new HashMap<String, HookInstanciationMethod>();
        res.put("Once", Once);
        res.put("OnceForRoot", OnceForRoot);
        res.put("OnceForAllNodes", OnceForAllNodes);
        res.put("Other", Other);
        res.put("ApplyToRoot", ApplyToRoot);
        return res;
    }

    public Collection getDestinationNodes(ModeController controller, MindMapNode focussed, List selecteds) {
        return this.getter.getDestinationNodes(controller, focussed, selecteds);
    }

    public boolean isAlreadyPresent(ModeController controller, String hookName, MindMapNode focussed) {
        Iterator i = focussed.getActivatedHooks().iterator();
        while (i.hasNext()) {
            PermanentNodeHook hook = (PermanentNodeHook)i.next();
            if (!hookName.equals(hook.getName())) continue;
            return true;
        }
        return false;
    }

    public MindMapNode getCenterNode(ModeController controller, MindMapNode focussed, List selecteds) {
        return this.getter.getCenterNode(controller, focussed, selecteds);
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    private static class AllDestinationNodesGetter
    implements DestinationNodesGetter {
        private AllDestinationNodesGetter() {
        }

        private void addChilds(MindMapNode node, Collection allNodeCollection) {
            allNodeCollection.add(node);
            ListIterator i = node.childrenFolded();
            while (i.hasNext()) {
                MindMapNode child = (MindMapNode)i.next();
                this.addChilds(child, allNodeCollection);
            }
        }

        public Collection getDestinationNodes(ModeController controller, MindMapNode focussed, List selecteds) {
            Vector returnValue = new Vector();
            this.addChilds(controller.getMap().getRootNode(), returnValue);
            return returnValue;
        }

        public MindMapNode getCenterNode(ModeController controller, MindMapNode focussed, List selecteds) {
            return focussed;
        }
    }

    private static class RootDestinationNodesGetter
    implements DestinationNodesGetter {
        private RootDestinationNodesGetter() {
        }

        public Collection getDestinationNodes(ModeController controller, MindMapNode focussed, List selecteds) {
            Vector<Object> returnValue = new Vector<Object>();
            returnValue.add(controller.getMap().getRoot());
            return returnValue;
        }

        public MindMapNode getCenterNode(ModeController controller, MindMapNode focussed, List selecteds) {
            return controller.getMap().getRootNode();
        }
    }

    private static class DefaultDestinationNodesGetter
    implements DestinationNodesGetter {
        private DefaultDestinationNodesGetter() {
        }

        public Collection getDestinationNodes(ModeController controller, MindMapNode focussed, List selecteds) {
            return selecteds;
        }

        public MindMapNode getCenterNode(ModeController controller, MindMapNode focussed, List selecteds) {
            return focussed;
        }
    }

    private static interface DestinationNodesGetter {
        public Collection getDestinationNodes(ModeController var1, MindMapNode var2, List var3);

        public MindMapNode getCenterNode(ModeController var1, MindMapNode var2, List var3);
    }
}

