/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom.traversal;

import java.util.concurrent.Callable;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.NodeImpl;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.dom.traversal.NodeFilterImpl;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeFilter;
import org.mozilla.interfaces.nsIDOMTreeWalker;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class TreeWalkerImpl
implements TreeWalker {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMTreeWalker getInstance() {
        return this.getInstanceAsnsIDOMTreeWalker();
    }

    protected TreeWalkerImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public TreeWalkerImpl(nsIDOMTreeWalker mozInst) {
        this((nsISupports)mozInst);
    }

    public static TreeWalkerImpl getDOMInstance(nsIDOMTreeWalker mozInst) {
        TreeWalkerImpl node = (TreeWalkerImpl)instances.get(mozInst);
        return node == null ? new TreeWalkerImpl(mozInst) : node;
    }

    public nsIDOMTreeWalker getInstanceAsnsIDOMTreeWalker() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMTreeWalker)this.moz.queryInterface("{400af3ca-1dd2-11b2-a50a-887ecca2e63a}");
    }

    public void setCurrentNode(Node currentNode) {
        final nsIDOMNode mozCurrentnode = currentNode != null ? ((NodeImpl)currentNode).getInstance() : null;
        Runnable r = new Runnable(){

            public void run() {
                TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().setCurrentNode(mozCurrentnode);
            }
        };
        ThreadProxy.getSingleton().syncExec(r);
    }

    public NodeFilter getFilter() {
        Callable<NodeFilter> c = new Callable<NodeFilter>(){

            @Override
            public NodeFilter call() {
                nsIDOMNodeFilter result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().getFilter();
                return new NodeFilterImpl(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node nextNode() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().nextNode();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node nextSibling() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().nextSibling();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node parentNode() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().parentNode();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node firstChild() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().firstChild();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getRoot() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().getRoot();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node getCurrentNode() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().getCurrentNode();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node previousNode() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().previousNode();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node lastChild() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().lastChild();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node previousSibling() {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().previousSibling();
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public boolean getExpandEntityReferences() {
        Callable<Boolean> c = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                boolean result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().getExpandEntityReferences();
                return result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public int getWhatToShow() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() {
                long result = TreeWalkerImpl.this.getInstanceAsnsIDOMTreeWalker().getWhatToShow();
                return (int)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

