/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;

public class RPNParser {
    private static final Map<String, Predicate> predicateByOperand;
    private static final Set<String> experimentalPredicates;
    private final String[] expression;
    private final boolean experimental;
    private final Stack<String> stack = new Stack();

    public RPNParser(String ... expression) {
        this(true, expression);
    }

    public RPNParser(boolean experimental, String ... expression) {
        this.expression = expression;
        this.experimental = experimental;
    }

    public boolean evaluate() {
        return this.evaluate(new StringLookup(){

            @Override
            public String lookup(String key) {
                return key;
            }
        });
    }

    public boolean evaluate(StringLookup lookup2) {
        for (String r : this.expression) {
            if (r == null) {
                throw new IllegalArgumentException("null input");
            }
            if (!predicateByOperand.containsKey(r)) {
                String val = lookup2.lookup(r);
                this.stack.push(val != null ? val : r);
                continue;
            }
            if (!this.experimental && experimentalPredicates.contains(r)) continue;
            this.evaluateOp(r);
        }
        if (this.stack.size() != 1) {
            throw new IllegalArgumentException(this.stack.size() + " elements at end of parse");
        }
        return Boolean.valueOf(this.stack.pop());
    }

    private void evaluateOp(String operand) {
        Predicate p = predicateByOperand.get(operand);
        if (this.stack.size() < p.numOperands()) {
            throw new IllegalArgumentException("not enough operands" + p.numOperands());
        }
        String[] strings = new String[p.numOperands()];
        for (int i = strings.length - 1; i >= 0; --i) {
            strings[i] = this.stack.pop();
        }
        this.stack.push(Boolean.toString(p.evaluate(strings)));
    }

    static boolean strictBoolean(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (s.equalsIgnoreCase("true")) {
            return true;
        }
        if (s.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException();
    }

    static {
        HashMap<String, Predicate> pMap = new HashMap<String, Predicate>();
        HashSet<String> eSet = new HashSet<String>();
        pMap.put("==", new EqualsPredicate());
        pMap.put("<", new LessPredicate());
        pMap.put(">", new GreaterPredicate());
        pMap.put("NOT", new NOTPredicate());
        pMap.put("OR", new ORPredicate());
        pMap.put("AND", new ANDPredicate());
        pMap.put("CONTAINS", new ContainsPredicate());
        pMap.put("MATCHES", new MatchesPredicate());
        eSet.add("MATCHES");
        predicateByOperand = Collections.unmodifiableMap(pMap);
        experimentalPredicates = Collections.unmodifiableSet(eSet);
    }

    static class MatchesPredicate
    extends Predicate {
        MatchesPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 2) {
                throw new IllegalArgumentException();
            }
            return Pattern.matches(operands[0], operands[1]);
        }
    }

    static class ContainsPredicate
    extends Predicate {
        ContainsPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 2) {
                throw new IllegalArgumentException();
            }
            return operands[0].toLowerCase().contains(operands[1].toLowerCase());
        }
    }

    static class LessPredicate
    extends Predicate {
        LessPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 2) {
                throw new IllegalArgumentException();
            }
            return Double.valueOf(operands[0]) < Double.valueOf(operands[1]);
        }
    }

    static class GreaterPredicate
    extends Predicate {
        GreaterPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 2) {
                throw new IllegalArgumentException();
            }
            return Double.valueOf(operands[0]) > Double.valueOf(operands[1]);
        }
    }

    static class NOTPredicate
    extends Predicate {
        NOTPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 1) {
                throw new IllegalArgumentException();
            }
            return !RPNParser.strictBoolean(operands[0]);
        }

        @Override
        public int numOperands() {
            return 1;
        }
    }

    static class ANDPredicate
    extends Predicate {
        ANDPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 2) {
                throw new IllegalArgumentException();
            }
            return RPNParser.strictBoolean(operands[0]) && RPNParser.strictBoolean(operands[1]);
        }
    }

    static class ORPredicate
    extends Predicate {
        ORPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 2) {
                throw new IllegalArgumentException();
            }
            return RPNParser.strictBoolean(operands[0]) || RPNParser.strictBoolean(operands[1]);
        }
    }

    static class EqualsPredicate
    extends Predicate {
        EqualsPredicate() {
        }

        @Override
        public boolean evaluate(String ... operands) {
            if (operands.length != 2) {
                throw new IllegalArgumentException();
            }
            return operands[0].equals(operands[1]);
        }
    }

    private static abstract class Predicate {
        private Predicate() {
        }

        public abstract boolean evaluate(String ... var1);

        public int numOperands() {
            return 2;
        }
    }

    public static interface StringLookup {
        public String lookup(String var1);
    }
}

