/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.limewire.core.api.Application;
import org.limewire.core.api.library.LibraryData;
import org.limewire.core.settings.InstallSettings;
import org.limewire.core.settings.SharingSettings;
import org.limewire.ui.swing.components.SegmentLayout;
import org.limewire.ui.swing.mainframe.StoreMediator;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.wizard.SetupComponentDecorator;
import org.limewire.ui.swing.wizard.WizardPage;
import org.limewire.util.OSUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public class SetupPage2
extends WizardPage {
    private final JCheckBox shareDownloadedFilesCheckBox;
    private final LibraryData libraryData;
    @Resource
    private Icon p2pSharedListIcon;
    @Resource
    private Icon sharingMyFilesNoStoreIcon;
    @Resource
    private Icon sharingMyFilesIcon;
    @Resource
    private Icon sharingArrowIcon;

    public SetupPage2(SetupComponentDecorator decorator, Application application, LibraryData libraryData) {
        super(decorator, application);
        JPanel oldVersionInfoPanel;
        this.libraryData = libraryData;
        GuiUtils.assignResources(this);
        this.setOpaque(false);
        this.setLayout(new SegmentLayout());
        this.shareDownloadedFilesCheckBox = this.createAndDecorateCheckBox(true);
        boolean newInstall = InstallSettings.PREVIOUS_RAN_VERSIONS.get().size() == 0;
        boolean fourUpgrade = this.isFourUpgrade();
        JPanel autoSharingPanel = this.createAutoSharingPanel(newInstall);
        autoSharingPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLACK));
        this.add(autoSharingPanel);
        this.add(this.createModifyInfoPanel());
        if (!newInstall && (oldVersionInfoPanel = this.createOldVersionInfoPanel(fourUpgrade)) != null) {
            oldVersionInfoPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.BLACK));
            this.add(oldVersionInfoPanel);
        }
        this.initSettings();
    }

    private boolean isFourUpgrade() {
        boolean has4 = false;
        boolean hasGreater = false;
        Iterator i$ = InstallSettings.PREVIOUS_RAN_VERSIONS.get().iterator();
        while (i$.hasNext()) {
            String previousVersion = (String)i$.next();
            try {
                Version version = new Version(previousVersion);
                if (version.getMajor() > 4) {
                    hasGreater = true;
                    continue;
                }
                if (version.getMajor() != 4) continue;
                has4 = true;
            }
            catch (VersionFormatException e) {}
        }
        return has4 && !hasGreater;
    }

    private void initSettings() {
        this.shareDownloadedFilesCheckBox.setSelected(SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue());
    }

    @Override
    public void applySettings() {
        SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.setValue(this.shareDownloadedFilesCheckBox.isSelected());
        SharingSettings.ALLOW_PARTIAL_SHARING.setValue(this.shareDownloadedFilesCheckBox.isSelected());
        InstallSettings.AUTO_SHARING_OPTION.setValue(true);
    }

    @Override
    public String getFooter() {
        return OSUtils.isMacOSX() ? I18n.tr("All settings can be changed later from LimeWire > Preferences") : I18n.tr("All settings can be changed later in Tools > Options");
    }

    @Override
    public String getLine1() {
        return I18n.tr("Learn about sharing.");
    }

    @Override
    public String getLine2() {
        return "";
    }

    private JPanel createAutoSharingPanel(boolean newInstall) {
        JPanel outerPanel = new JPanel(new GridBagLayout());
        JPanel autoSharingPanel = new JPanel(new MigLayout("insets 0, gap 0, nogrid"));
        autoSharingPanel.add((Component)this.createAndDecorateHeader(I18n.tr("Files in your Public Shared list are shared with the world.")), "alignx center, wrap");
        if (newInstall) {
            autoSharingPanel.add(this.shareDownloadedFilesCheckBox);
            autoSharingPanel.add(this.createAndDecorateMultiLine(I18n.tr("Add files I download from P2P Users to my Public Shared list."), this.shareDownloadedFilesCheckBox));
            autoSharingPanel.add((Component)this.createAndDecorateHyperlink("http://www.limewire.com/client_redirect/?page=autoSharingMoreInfo"), "wrap");
        } else if (SharingSettings.SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES.getValue()) {
            autoSharingPanel.add(this.createAndDecorateSubHeading(I18n.tr("LimeWire will add files you download from P2P Users into your Public Shared list.")), "alignx center");
            autoSharingPanel.add((Component)this.createAndDecorateHyperlink("http://www.limewire.com/client_redirect/?page=autoSharingMoreInfo"), "wrap");
        }
        outerPanel.add((Component)autoSharingPanel, new GridBagConstraints());
        return outerPanel;
    }

    private JPanel createModifyInfoPanel() {
        JPanel outerPanel = new JPanel(new GridBagLayout());
        Icon myFilesIcon = null;
        myFilesIcon = StoreMediator.canShowStoreButton() ? this.sharingMyFilesIcon : this.sharingMyFilesNoStoreIcon;
        JPanel modifyInfoPanel = new JPanel(new MigLayout("fill, insets 0, gap 0, nogrid"));
        modifyInfoPanel.add((Component)this.createAndDecorateHeader(I18n.tr("To see or modify files in your Public Shared list, go to")), "alignx center, wrap");
        JLabel myFiles = new JLabel(I18n.tr("My Files"), myFilesIcon, 0);
        myFiles.setVerticalTextPosition(3);
        myFiles.setHorizontalTextPosition(0);
        modifyInfoPanel.add((Component)myFiles, "alignx center");
        modifyInfoPanel.add((Component)new JLabel(this.sharingArrowIcon), "aligny top, gaptop 17");
        modifyInfoPanel.add((Component)new JLabel(I18n.tr("Public Shared"), this.p2pSharedListIcon, 4), "aligny top, gaptop 15");
        outerPanel.add((Component)modifyInfoPanel, new GridBagConstraints());
        return outerPanel;
    }

    private int peekNumPublicSharedFiles() {
        int numPublicFiles = this.libraryData.peekPublicSharedListCount();
        return numPublicFiles;
    }

    private JPanel createOldVersionInfoPanel(boolean fourUpgrade) {
        JLabel label;
        JPanel outerPanel = new JPanel(new GridBagLayout());
        if (fourUpgrade) {
            label = this.createAndDecorateHeader(I18n.tr("Shared files from your old version will continue to be shared with the world."));
        } else {
            int numSharedFiles = this.peekNumPublicSharedFiles();
            if (numSharedFiles > 0) {
                label = this.createAndDecorateHeader(I18n.tr("{0} shared files from your previous version will continue to be shared with the world.", numSharedFiles));
            } else {
                return null;
            }
        }
        outerPanel.add((Component)label, new GridBagConstraints());
        return outerPanel;
    }
}

