/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.statusbar;

import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.swing.SwingThreadProxyEventList;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Resource;
import org.jdesktop.swingx.JXPanel;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.library.SharedFileList;
import org.limewire.core.api.library.SharedFileListManager;
import org.limewire.friend.api.FriendConnection;
import org.limewire.friend.api.FriendConnectionEvent;
import org.limewire.listener.EventBean;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.PopupHeaderBar;
import org.limewire.ui.swing.components.Resizable;
import org.limewire.ui.swing.components.decorators.ButtonDecorator;
import org.limewire.ui.swing.friends.login.AutoLoginService;
import org.limewire.ui.swing.friends.login.LoginPopupPanel;
import org.limewire.ui.swing.library.LibraryMediator;
import org.limewire.ui.swing.painter.StatusBarPopupButtonPainter;
import org.limewire.ui.swing.statusbar.SharedFileCountPanel;
import org.limewire.ui.swing.table.MouseableTable;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.PainterUtils;

public class SharedFileCountPopupPanel
extends Panel
implements Resizable {
    private static final String ICON_COLUMN_ID = "Icon";
    private static final String NAME_COLUMN_ID = "Name";
    private static final String BLANK_COLUMN_ID = "Blank";
    private static final String FILES_COLUMN_ID = "Files";
    private static final int ROW_HEIGHT = 18;
    @Resource
    private Color background = PainterUtils.TRASPARENT;
    @Resource
    private Color border = PainterUtils.TRASPARENT;
    @Resource
    private Icon publicIcon;
    @Resource
    private Icon listSharedIcon;
    @Resource
    private Font listTextFont;
    @Resource
    private Color listTextForeground;
    @Resource
    private Font signInTextFont;
    private final SharedFileCountPanel sharedFileCountPanel;
    private final SharedFileListManager shareListManager;
    private final Provider<LoginPopupPanel> loginPanelProvider;
    private final ListenerSupport<FriendConnectionEvent> connectionSupport;
    private final LibraryMediator libraryMediator;
    private final Provider<AutoLoginService> autoLoginServiceProvider;
    private Timer repaintTimer = null;
    private JXPanel frame = null;
    private MouseableTable table = null;
    private VisiblityMatcher matcher = null;
    private FilterList<SharedFileList> filteredSharedFileLists;
    private final AbstractAction closeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SharedFileCountPopupPanel.this.setVisible(false);
            SharedFileCountPopupPanel.this.sharedFileCountPanel.repaint();
        }
    };
    private HyperlinkButton signIntoFriendsButton = null;
    private final EventBean<FriendConnectionEvent> friendConnectionBean;

    @Inject
    public SharedFileCountPopupPanel(SharedFileCountPanel sharedFileCountPanel, SharedFileListManager shareListManager, Provider<LoginPopupPanel> loginPanelProvider, ListenerSupport<FriendConnectionEvent> connectionSupport, LibraryMediator libraryMediator, Provider<AutoLoginService> autoLoginServiceProvider, EventBean<FriendConnectionEvent> friendConnectionBean, ButtonDecorator buttonDecorator) {
        super(new BorderLayout());
        this.sharedFileCountPanel = sharedFileCountPanel;
        this.shareListManager = shareListManager;
        this.loginPanelProvider = loginPanelProvider;
        this.connectionSupport = connectionSupport;
        this.libraryMediator = libraryMediator;
        this.autoLoginServiceProvider = autoLoginServiceProvider;
        this.friendConnectionBean = friendConnectionBean;
        GuiUtils.assignResources(this);
        this.setUpButton(buttonDecorator);
        this.setVisible(false);
    }

    @Inject
    public void register() {
        this.sharedFileCountPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SharedFileCountPopupPanel.this.setVisible(!SharedFileCountPopupPanel.this.isVisible() && SharedFileCountPopupPanel.this.shareListManager.getSharedFileCount() != 0);
                SharedFileCountPopupPanel.this.sharedFileCountPanel.repaint();
            }
        });
        this.sharedFileCountPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (SharedFileCountPopupPanel.this.isVisible()) {
                    SharedFileCountPopupPanel.this.resize();
                }
            }
        });
    }

    private void initContent() {
        this.frame = new JXPanel(new BorderLayout());
        this.frame.setPreferredSize(new Dimension(225, 160));
        PopupHeaderBar topBarPanel = new PopupHeaderBar(I18n.tr("Lists I'm Sharing"), this.closeAction);
        this.frame.add((Component)topBarPanel, "North");
        JPanel contentPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setOpaque(false);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        contentPanel.setOpaque(false);
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 1, this.border), BorderFactory.createEmptyBorder(5, 4, 4, 4)));
        this.filteredSharedFileLists = new FilterList<SharedFileList>(this.shareListManager.getModel());
        this.matcher = new VisiblityMatcher();
        this.filteredSharedFileLists.setMatcher(this.matcher);
        SwingThreadProxyEventList<SharedFileList> stpl = GlazedListsFactory.swingThreadProxyEventList(this.filteredSharedFileLists);
        this.table = new MouseableTable(new DefaultEventTableModel<SharedFileList>(stpl, new TableFormat<SharedFileList>(){

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public String getColumnName(int column) {
                if (column == 0) {
                    return SharedFileCountPopupPanel.ICON_COLUMN_ID;
                }
                if (column == 1) {
                    return SharedFileCountPopupPanel.NAME_COLUMN_ID;
                }
                if (column == 2) {
                    return SharedFileCountPopupPanel.BLANK_COLUMN_ID;
                }
                return SharedFileCountPopupPanel.FILES_COLUMN_ID;
            }

            @Override
            public Object getColumnValue(SharedFileList baseObject, int column) {
                if (column == 0) {
                    if (baseObject.isPublic()) {
                        return SharedFileCountPopupPanel.this.publicIcon;
                    }
                    return SharedFileCountPopupPanel.this.listSharedIcon;
                }
                if (column == 1) {
                    return baseObject.getCollectionName();
                }
                if (column == 2) {
                    return null;
                }
                return I18n.trn("{0} file", "{0} files", baseObject.size());
            }
        }));
        this.table.setAutoResizeMode(0);
        TableColumn iconColumn = this.table.getColumn(ICON_COLUMN_ID);
        iconColumn.setCellRenderer(new IconRenderer());
        iconColumn.setPreferredWidth(this.publicIcon.getIconWidth());
        iconColumn.setMaxWidth(this.publicIcon.getIconWidth());
        LinkRenderer linkRenderer = new LinkRenderer();
        linkRenderer.setFont(this.listTextFont);
        LinkEditor linkEditor = new LinkEditor();
        linkEditor.setFont(this.listTextFont);
        TableColumn nameColumn = this.table.getColumn(NAME_COLUMN_ID);
        nameColumn.setCellRenderer(linkRenderer);
        nameColumn.setCellEditor(linkEditor);
        TableColumn blankColumn = this.table.getColumn(BLANK_COLUMN_ID);
        blankColumn.setPreferredWidth(20);
        blankColumn.setMinWidth(20);
        blankColumn.setMaxWidth(20);
        this.table.getColumn(FILES_COLUMN_ID).setPreferredWidth(0);
        this.table.setFont(this.listTextFont);
        this.table.setForeground(this.listTextForeground);
        this.table.setOpaque(false);
        this.table.setShowGrid(false);
        this.table.setFocusable(false);
        this.table.setCellSelectionEnabled(false);
        this.table.setRowHeight(18);
        this.table.setStripeHighlighterEnabled(false);
        this.table.setEmptyRowsPainted(false);
        this.repaintTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SharedFileCountPopupPanel.this.repaint();
            }
        });
        final Timer resizeTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SharedFileCountPopupPanel.this.resize();
            }
        });
        this.repaintTimer.setRepeats(false);
        final RepaintListener repaintListener = new RepaintListener();
        for (SharedFileList item : this.shareListManager.getModel()) {
            item.getSwingModel().addListEventListener(repaintListener);
        }
        this.shareListManager.getModel().addListEventListener(new ListEventListener<SharedFileList>(){

            @Override
            public void listChanged(ListEvent<SharedFileList> listChanges) {
                while (listChanges.next()) {
                    if (listChanges.getType() != 2) continue;
                    SharedFileList newList = (SharedFileList)listChanges.getSourceList().get(listChanges.getIndex());
                    newList.getModel().addListEventListener(repaintListener);
                }
                resizeTimer.start();
            }
        });
        contentPanel.add((Component)this.table, "Center");
        JPanel bottomPanel = new JPanel(new MigLayout("gap 0, insets 0, align center"));
        bottomPanel.setOpaque(false);
        this.setUpAndAddSignInButton(bottomPanel);
        contentPanel.add((Component)bottomPanel, "South");
        this.frame.add((Component)scrollPane, "Center");
        this.add((Component)this.frame, "Center");
    }

    private void setUpAndAddSignInButton(final JPanel panel) {
        if (this.shouldShowSignInButton()) {
            this.signIntoFriendsButton = new HyperlinkButton(new AbstractAction(I18n.tr("Sign in to share with friends")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((LoginPopupPanel)SharedFileCountPopupPanel.this.loginPanelProvider.get()).setVisible(true);
                }
            });
            this.signIntoFriendsButton.setFont(this.signInTextFont);
            panel.add(this.signIntoFriendsButton);
            this.connectionSupport.addListener(new EventListener<FriendConnectionEvent>(){

                @Override
                @SwingEDTEvent
                public void handleEvent(FriendConnectionEvent event) {
                    if (!SharedFileCountPopupPanel.this.shouldShowSignInButton()) {
                        SharedFileCountPopupPanel.this.connectionSupport.removeListener(this);
                        panel.remove(SharedFileCountPopupPanel.this.signIntoFriendsButton);
                        SharedFileCountPopupPanel.this.signIntoFriendsButton = null;
                        SharedFileCountPopupPanel.this.validate();
                        SharedFileCountPopupPanel.this.resize();
                        SharedFileCountPopupPanel.this.repaint();
                    }
                }
            });
        }
    }

    private boolean shouldShowSignInButton() {
        FriendConnection friendConnection;
        FriendConnectionEvent lastEvent = this.friendConnectionBean.getLastEvent();
        FriendConnection friendConnection2 = friendConnection = lastEvent != null ? (FriendConnection)lastEvent.getSource() : null;
        if (friendConnection != null && (friendConnection.isLoggedIn() || friendConnection.isLoggingIn()) || this.autoLoginServiceProvider.get().isAttemptingLogin()) {
            return false;
        }
        if (this.shareListManager.getModel().size() == 1) {
            return true;
        }
        for (SharedFileList list : this.shareListManager.getModel()) {
            if (list.isPublic() || list.getFriendIds().size() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.table == null && visible) {
            this.initContent();
        }
        if (visible) {
            this.resize();
            this.validate();
            this.frame.repaint();
        }
    }

    private int getRowsToShow() {
        int rows = this.filteredSharedFileLists.size();
        return rows > 10 ? 10 : rows;
    }

    @Override
    public void resize() {
        Rectangle parentBounds = this.getParent().getBounds();
        Dimension childPreferredSize = this.frame.getPreferredSize();
        int w = (int)childPreferredSize.getWidth();
        int h = 32 + 18 * this.getRowsToShow() + (this.signIntoFriendsButton == null ? 0 : 15);
        this.setBounds((int)this.sharedFileCountPanel.getBounds().getX(), (int)parentBounds.getHeight() - h, w, h);
    }

    private void setUpButton(ButtonDecorator buttonDecorator) {
        buttonDecorator.decorateStatusPopupButton(this.sharedFileCountPanel, new StatusBarPopupButtonPainter.PopupVisibilityChecker(){

            @Override
            public boolean isPopupVisible() {
                return SharedFileCountPopupPanel.this.isVisible();
            }
        }, this.background, this.border, StatusBarPopupButtonPainter.DrawMode.RIGHT_CONNECTING);
        this.sharedFileCountPanel.setEnabled(this.shareListManager.getSharedFileCount() != 0);
        this.shareListManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("sharedFileCount")) {
                    SharedFileCountPopupPanel.this.sharedFileCountPanel.setEnabled(SharedFileCountPopupPanel.this.shareListManager.getSharedFileCount() != 0);
                }
            }
        });
    }

    private static class VisiblityMatcher
    implements Matcher<SharedFileList> {
        private VisiblityMatcher() {
        }

        @Override
        public boolean matches(SharedFileList item) {
            return item.isPublic() || item.getFriendIds().size() != 0;
        }
    }

    private static class SharedFileListHyperLinkButton
    extends HyperlinkButton {
        private int filteredListIndex = -1;

        public SharedFileListHyperLinkButton(Action a) {
            super(a);
        }

        public void setFilteredListIndex(int i) {
            this.filteredListIndex = i;
        }

        public int getFilteredListIndex() {
            return this.filteredListIndex;
        }

        @Override
        public void setForeground(Color c) {
        }
    }

    private class LinkEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final SharedFileListHyperLinkButton button = new SharedFileListHyperLinkButton(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SharedFileCountPopupPanel.this.libraryMediator.showSharedFileList((SharedFileList)SharedFileCountPopupPanel.this.filteredSharedFileLists.get(LinkEditor.this.button.getFilteredListIndex()));
            }
        });

        private LinkEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            this.button.setText(value.toString());
            this.button.setFilteredListIndex(row);
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button;
        }

        public void setFont(Font f) {
            this.button.setFont(f);
        }
    }

    private static class LinkRenderer
    extends HyperlinkButton
    implements TableCellRenderer {
        private LinkRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            this.setText(value.toString());
            return this;
        }

        @Override
        public void setForeground(Color c) {
        }
    }

    private static class IconRenderer
    extends JLabel
    implements TableCellRenderer {
        private IconRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof Icon)) {
                return null;
            }
            this.setIcon((Icon)value);
            return this;
        }
    }

    private class RepaintListener
    implements ListEventListener {
        private RepaintListener() {
        }

        public void listChanged(ListEvent listChanges) {
            SharedFileCountPopupPanel.this.repaintTimer.start();
        }
    }
}

