/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.options;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.limewire.core.api.Application;
import org.limewire.core.settings.ApplicationSettings;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.action.UrlAction;
import org.limewire.ui.swing.components.HyperlinkButton;
import org.limewire.ui.swing.components.LanguageComboBox;
import org.limewire.ui.swing.components.NonNullJComboBox;
import org.limewire.ui.swing.components.TextFieldClipboardControl;
import org.limewire.ui.swing.friends.settings.FriendAccountConfiguration;
import org.limewire.ui.swing.friends.settings.FriendAccountConfigurationManager;
import org.limewire.ui.swing.options.LearnMoreButton;
import org.limewire.ui.swing.options.OptionPanel;
import org.limewire.ui.swing.settings.QuestionsHandler;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.LanguageUtils;
import org.limewire.ui.swing.util.SwingUtils;

public class MiscOptionPanel
extends OptionPanel {
    private static final int SKIP_WARNING_VALUE = 101;
    private static final int SHOW_WARNING_VALUE = 0;
    private static final String TRANSLATE_URL = "http://wiki.limewire.org/index.php?title=Translate";
    private final Provider<FriendAccountConfigurationManager> accountManager;
    private NotificationsPanel notificationsPanel;
    private FriendsChatPanel friendsChatPanel;
    private Locale currentLanguage;
    private JLabel comboLabel;
    private final JComboBox languageDropDown;
    private final HyperlinkButton translateButton;
    private final JCheckBox shareUsageDataCheckBox;

    @Inject
    public MiscOptionPanel(Provider<FriendAccountConfigurationManager> accountManager, Application application) {
        this.accountManager = accountManager;
        GuiUtils.assignResources(this);
        this.setLayout(new MigLayout("nogrid, insets 15 15 15 15, fillx, gap 4"));
        this.comboLabel = new JLabel(I18n.tr("Language:"));
        this.languageDropDown = new LanguageComboBox();
        this.translateButton = new HyperlinkButton(new UrlAction(I18n.tr("Help translate LimeWire!"), TRANSLATE_URL, application));
        this.add(this.comboLabel);
        this.add(this.languageDropDown);
        this.add((Component)this.translateButton, "wrap");
        this.add((Component)this.getNotificationsPanel(), "growx, wrap");
        this.add((Component)this.getFriendChatPanel(), "growx, wrap");
        this.shareUsageDataCheckBox = new JCheckBox(I18n.tr("Help improve LimeWire by sending us anonymous usage data"));
        this.shareUsageDataCheckBox.setOpaque(false);
        this.add(this.shareUsageDataCheckBox);
        this.add((Component)new LearnMoreButton("http://www.limewire.com/client_redirect/?page=anonymousDataCollection", application), "wrap");
    }

    private OptionPanel getNotificationsPanel() {
        if (this.notificationsPanel == null) {
            this.notificationsPanel = new NotificationsPanel();
        }
        return this.notificationsPanel;
    }

    private OptionPanel getFriendChatPanel() {
        if (this.friendsChatPanel == null) {
            this.friendsChatPanel = new FriendsChatPanel();
        }
        return this.friendsChatPanel;
    }

    @Override
    boolean applyOptions() {
        ApplicationSettings.ALLOW_ANONYMOUS_STATISTICS_GATHERING.setValue(this.shareUsageDataCheckBox.isSelected());
        Locale selectedLocale = (Locale)this.languageDropDown.getSelectedItem();
        boolean restart = this.getNotificationsPanel().applyOptions();
        restart |= this.getFriendChatPanel().applyOptions();
        if (selectedLocale != null && !this.currentLanguage.equals(selectedLocale)) {
            this.currentLanguage = selectedLocale;
            LanguageUtils.setLocale(selectedLocale);
            restart = true;
        }
        return restart;
    }

    @Override
    boolean hasChanged() {
        Locale selectedLocale = (Locale)this.languageDropDown.getSelectedItem();
        return this.getNotificationsPanel().hasChanged() || this.getFriendChatPanel().hasChanged() || selectedLocale != this.currentLanguage || ApplicationSettings.ALLOW_ANONYMOUS_STATISTICS_GATHERING.getValue() != this.shareUsageDataCheckBox.isSelected();
    }

    @Override
    public void initOptions() {
        this.shareUsageDataCheckBox.setSelected(ApplicationSettings.ALLOW_ANONYMOUS_STATISTICS_GATHERING.getValue());
        this.getNotificationsPanel().initOptions();
        this.getFriendChatPanel().initOptions();
        this.currentLanguage = LanguageUtils.getCurrentLocale();
        if (this.currentLanguage == null) {
            LanguageUtils.setLocale(Locale.ENGLISH);
            this.currentLanguage = Locale.ENGLISH;
        }
        this.languageDropDown.setSelectedItem(this.currentLanguage);
    }

    private static void resetWarnings() {
        int skipWarningSettingValue = MiscOptionPanel.getLicenseSettingValueFromCheckboxValue(true);
        QuestionsHandler.SKIP_FIRST_DOWNLOAD_WARNING.setValue(skipWarningSettingValue);
        QuestionsHandler.WARN_TORRENT_SEED_MORE.revertToDefault();
        QuestionsHandler.CONFIRM_BLOCK_HOST.revertToDefault();
        SwingUiSettings.WARN_DOWNLOAD_DANGEROUS.revertToDefault();
        SwingUiSettings.WARN_DOWNLOAD_SCAN_FAILED.revertToDefault();
        SwingUiSettings.WARN_DOWNLOAD_THREAT_FOUND.revertToDefault();
    }

    private static int getLicenseSettingValueFromCheckboxValue(boolean isSelected) {
        return isSelected ? 0 : 101;
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            FriendAccountConfiguration config = ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).getConfig(value.toString());
            if (config != null) {
                this.setIcon(config.getIcon());
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }

    private class FriendsChatPanel
    extends OptionPanel
    implements SettingListener {
        private JCheckBox autoLoginCheckBox;
        private JComboBox serviceComboBox;
        private JLabel serviceLabel;
        private JTextField serviceField;
        private JTextField usernameField;
        private JPasswordField passwordField;

        public FriendsChatPanel() {
            super(I18n.tr("Friends and Chat"));
            SwingUiSettings.XMPP_AUTO_LOGIN.addSettingListener(this);
            this.autoLoginCheckBox = new JCheckBox(I18n.tr("Sign into Friends when LimeWire starts"));
            this.autoLoginCheckBox.setContentAreaFilled(false);
            this.autoLoginCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FriendsChatPanel.this.setComponentsEnabled(FriendsChatPanel.this.autoLoginCheckBox.isSelected());
                }
            });
            this.serviceComboBox = new NonNullJComboBox();
            for (String label : ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).getLabels()) {
                if (label.equals("Facebook")) continue;
                this.serviceComboBox.addItem(label);
            }
            this.serviceComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FriendsChatPanel.this.populateInputs();
                }
            });
            this.serviceComboBox.setRenderer(new Renderer());
            this.serviceLabel = new JLabel(I18n.tr("Jabber Server:"));
            this.serviceField = new JTextField(18);
            this.usernameField = new JTextField(18);
            this.passwordField = new JPasswordField(18);
            TextFieldClipboardControl.install(this.serviceField);
            TextFieldClipboardControl.install(this.usernameField);
            TextFieldClipboardControl.install(this.passwordField);
            this.add((Component)this.autoLoginCheckBox, "wrap");
            JPanel servicePanel = new JPanel(new MigLayout("insets 0, fill"));
            servicePanel.setOpaque(false);
            servicePanel.add((Component)new JLabel(I18n.tr("Using:")), "gapleft 25");
            servicePanel.add((Component)this.serviceComboBox, "wrap");
            servicePanel.add((Component)this.serviceLabel, "gapleft 25, hidemode 3");
            servicePanel.add((Component)this.serviceField, "hidemode 3, wrap");
            servicePanel.add((Component)new JLabel(I18n.tr("Username:")), "gapleft 25");
            servicePanel.add((Component)this.usernameField, "wrap");
            servicePanel.add((Component)new JLabel(I18n.tr("Password:")), "gapleft 25");
            servicePanel.add((Component)this.passwordField, "wrap");
            this.add(servicePanel);
        }

        private void populateInputs() {
            String label = (String)this.serviceComboBox.getSelectedItem();
            if (label.equals("Jabber")) {
                this.serviceLabel.setVisible(true);
                this.serviceField.setVisible(true);
            } else {
                this.serviceLabel.setVisible(false);
                this.serviceField.setVisible(false);
            }
            FriendAccountConfiguration config = ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).getConfig(label);
            if (config == ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).getAutoLoginConfig()) {
                this.serviceField.setText(config.getServiceName());
                this.usernameField.setText(config.getUserInputLocalID());
                this.passwordField.setText(config.getPassword());
            } else {
                this.serviceField.setText("");
                this.usernameField.setText("");
                this.passwordField.setText("");
            }
        }

        private void setComponentsEnabled(boolean enabled) {
            this.serviceComboBox.setEnabled(enabled);
            this.serviceField.setEnabled(enabled);
            this.usernameField.setEnabled(enabled);
            this.passwordField.setEnabled(enabled);
            if (!enabled) {
                this.serviceField.setText("");
                this.usernameField.setText("");
                this.passwordField.setText("");
                ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).setAutoLoginConfig(null);
            }
        }

        @Override
        boolean applyOptions() {
            if (this.hasChanged()) {
                if (this.autoLoginCheckBox.isSelected()) {
                    String user = this.usernameField.getText().trim();
                    String password = new String(this.passwordField.getPassword());
                    if (user.equals("") || password.equals("")) {
                        return false;
                    }
                    String label = (String)this.serviceComboBox.getSelectedItem();
                    FriendAccountConfiguration config = ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).getConfig(label);
                    if (label.equals("Jabber")) {
                        String service = this.serviceField.getText().trim();
                        if (service.equals("")) {
                            return false;
                        }
                        config.setServiceName(service);
                    }
                    config.setUsername(user);
                    config.setPassword(password);
                    ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).setAutoLoginConfig(config);
                } else {
                    ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).setAutoLoginConfig(null);
                }
            }
            return false;
        }

        @Override
        boolean hasChanged() {
            FriendAccountConfiguration auto = ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).getAutoLoginConfig();
            if (auto == null) {
                return this.autoLoginCheckBox.isSelected();
            }
            if (!this.autoLoginCheckBox.isSelected()) {
                return true;
            }
            String label = (String)this.serviceComboBox.getSelectedItem();
            if (!label.equals(auto.getLabel())) {
                return true;
            }
            String serviceName = this.serviceField.getText().trim();
            if (!serviceName.equals(auto.getServiceName())) {
                return true;
            }
            String username = this.usernameField.getText().trim();
            if (!username.equals(auto.getUserInputLocalID())) {
                return true;
            }
            String password = new String(this.passwordField.getPassword());
            return !password.equals(auto.getPassword());
        }

        @Override
        public void initOptions() {
            FriendAccountConfiguration auto = ((FriendAccountConfigurationManager)MiscOptionPanel.this.accountManager.get()).getAutoLoginConfig();
            if (auto == null) {
                this.serviceComboBox.setSelectedItem("Gmail");
                this.setComponentsEnabled(false);
                this.autoLoginCheckBox.setSelected(false);
            } else {
                this.serviceComboBox.setSelectedItem(auto.getLabel());
                this.setComponentsEnabled(true);
                this.autoLoginCheckBox.setSelected(true);
            }
            this.populateInputs();
        }

        @Override
        public void settingChanged(SettingEvent evt) {
            SwingUtils.invokeNowOrLater(new Runnable(){

                @Override
                public void run() {
                    FriendsChatPanel.this.initOptions();
                }
            });
        }
    }

    private class NotificationsPanel
    extends OptionPanel {
        private JCheckBox showNotificationsCheckBox;
        private JButton resetWarningsButton;

        public NotificationsPanel() {
            super(I18n.tr("Notifications and Warnings"));
            this.showNotificationsCheckBox = new JCheckBox(I18n.tr("Show popup system notifications"));
            this.showNotificationsCheckBox.setContentAreaFilled(false);
            this.resetWarningsButton = new JButton(new AbstractAction(I18n.tr("Reset")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MiscOptionPanel.resetWarnings();
                }
            });
            this.add((Component)this.showNotificationsCheckBox, "wrap");
            this.add(new JLabel(I18n.tr("Reset warning messages")));
            this.add((Component)this.resetWarningsButton, "wrap");
        }

        @Override
        boolean applyOptions() {
            SwingUiSettings.SHOW_NOTIFICATIONS.setValue(this.showNotificationsCheckBox.isSelected());
            return false;
        }

        @Override
        boolean hasChanged() {
            return this.showNotificationsCheckBox.isSelected() != SwingUiSettings.SHOW_NOTIFICATIONS.getValue();
        }

        @Override
        public void initOptions() {
            this.showNotificationsCheckBox.setSelected(SwingUiSettings.SHOW_NOTIFICATIONS.getValue());
        }
    }
}

