/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.navigator;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.limewire.ui.swing.action.AbstractAction;
import org.limewire.ui.swing.library.navigator.LibraryNavItem;
import org.limewire.ui.swing.library.navigator.LibraryNavigatorPanel;
import org.limewire.ui.swing.library.navigator.M3UList;
import org.limewire.ui.swing.util.FileChooser;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;

class ImportListAction
extends AbstractAction {
    private final LibraryNavigatorPanel libraryNavigatorPanel;

    @Inject
    public ImportListAction(LibraryNavigatorPanel libraryNavigatorPanel) {
        super(I18n.tr("Import List..."));
        this.libraryNavigatorPanel = libraryNavigatorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LibraryNavItem item = this.libraryNavigatorPanel.getSelectedNavItem();
        File file = FileChooser.getInputFile(GuiUtils.getMainFrame(), I18n.tr("Import M3U List"), I18n.tr("Load"), FileChooser.getLastInputDirectory(), new M3UFileFilter());
        if (file == null) {
            return;
        }
        M3UList m3uList = new M3UList(file, item.getLocalFileList());
        m3uList.load();
    }

    private static class M3UFileFilter
    extends FileFilter {
        private M3UFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("m3u");
        }

        @Override
        public String getDescription() {
            return I18n.tr("Playlist Files (*.m3u)");
        }
    }
}

