/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.images;

import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

class ImageRenderer
extends JComponent {
    private final JLabel label;
    private Icon icon;

    @Inject
    public ImageRenderer() {
        this.setPreferredSize(new Dimension(116, 86));
        this.setSize(this.getPreferredSize());
        this.setLayout(null);
        this.setOpaque(false);
        this.label = new JLabel();
        this.label.setVisible(false);
        this.label.setOpaque(false);
        this.label.setForeground(Color.BLACK);
        this.label.setHorizontalAlignment(0);
        this.calculateLabelDimnensions();
        this.add(this.label);
    }

    private void calculateLabelDimnensions() {
        int x = (this.getWidth() - this.getInsets().left - this.getInsets().right - 116) / 2 + this.getInsets().left;
        int y = this.getInsets().top + 43 + 15;
        this.label.setBounds(x, y, 116, 26);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setText(String text) {
        this.label.setText(text);
        if (text == null || text.length() == 0) {
            this.label.setVisible(false);
        } else {
            this.label.setVisible(true);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isVisible() && this.icon != null) {
            int iconX = (this.getWidth() - this.icon.getIconWidth()) / 2;
            int iconY = (86 - this.icon.getIconHeight()) / 2;
            this.icon.paintIcon(this, g, 0 + iconX, 0 + iconY);
        }
    }
}

