/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import java.util.Collection;
import org.limewire.friend.api.Friend;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.SourceItem;
import org.limewire.util.Objects;

class SourceMatcher<E extends FilterableItem>
implements Matcher<E> {
    private final SourceItem sourceItem;

    public SourceMatcher(SourceItem sourceItem) {
        this.sourceItem = sourceItem;
    }

    @Override
    public boolean matches(E item) {
        switch (this.sourceItem.getType()) {
            case ANONYMOUS: {
                return item.isAnonymous();
            }
            case ANY_FRIEND: {
                return item.getFriends().size() > 0;
            }
        }
        Collection<Friend> friends = item.getFriends();
        String name = this.sourceItem.getName();
        for (Friend friend : friends) {
            if (Objects.compareToNullIgnoreCase(name, friend.getRenderName(), false) != 0) continue;
            return true;
        }
        return false;
    }
}

