/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads.table;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellEditor;
import org.limewire.core.api.Category;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.endpoint.RemoteHost;
import org.limewire.ui.swing.downloads.table.DownloadActionHandler;
import org.limewire.ui.swing.downloads.table.DownloadTable;
import org.limewire.ui.swing.downloads.table.FinishedDownloadSelected;
import org.limewire.ui.swing.library.table.ListMenuFactory;
import org.limewire.ui.swing.search.BlockUserMenuFactory;
import org.limewire.ui.swing.search.RemoteHostMenuFactory;
import org.limewire.ui.swing.util.I18n;

public class DownloadTableMenu
extends JPopupMenu {
    private final MenuListener menuListener;
    private final DownloadActionHandler actionHandler;
    private final DownloadTable table;
    private final RemoteHostMenuFactory remoteHostMenuFactory;
    private final BlockUserMenuFactory blockUserMenuFactory;
    private final ListMenuFactory listMenuFactory;
    private final Provider<List<File>> selectedFiles;
    private List<DownloadItem> downloadItems;

    @Inject
    public DownloadTableMenu(RemoteHostMenuFactory remoteHostMenuFactory, BlockUserMenuFactory blockUserMenuFactory, DownloadActionHandler actionHandler, ListMenuFactory listMenuFactory, @FinishedDownloadSelected Provider<List<File>> selectedFiles, @Assisted DownloadTable table) {
        this.remoteHostMenuFactory = remoteHostMenuFactory;
        this.blockUserMenuFactory = blockUserMenuFactory;
        this.actionHandler = actionHandler;
        this.table = table;
        this.listMenuFactory = listMenuFactory;
        this.selectedFiles = selectedFiles;
        this.menuListener = new MenuListener();
        this.update(table.getSelectedItems());
    }

    public void update(List<DownloadItem> downloadItems) {
        this.downloadItems = downloadItems;
        this.removeAll();
        if (downloadItems.size() == 1) {
            this.initializeSingleItemMenu(downloadItems.get(0));
        } else {
            this.initializeMultiItemMenu(downloadItems);
        }
    }

    private void initializeSingleItemMenu(DownloadItem downloadItem) {
        DownloadState state = downloadItem.getState();
        if (state == DownloadState.DONE || state == DownloadState.SCAN_FAILED || state == DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS) {
            this.add(this.createLaunchMenuItem()).setEnabled(downloadItem.isLaunchable());
            this.add(this.createRemoveMenuItem());
            this.addSeparator();
            this.add(this.createLocateOnDiskMenuItem());
            this.add(this.createLocateInLibraryMenuItem());
            this.addSeparator();
            this.add(this.listMenuFactory.createAddToListMenu(this.selectedFiles));
            this.add(this.listMenuFactory.createShowInListMenu(this.selectedFiles, true));
            this.addSeparator();
            this.add(this.createPropertiesMenuItem());
        } else if (state == DownloadState.DANGEROUS || state == DownloadState.THREAT_FOUND) {
            this.add(this.createRemoveMenuItem());
        } else {
            if (this.isResumable(state)) {
                this.add(this.createResumeMenuItem());
            }
            if (this.isPausable(state)) {
                this.add(this.createPauseMenuItem());
            }
            if (this.isTryAgainable(state)) {
                this.add(this.createTryAgainMenuItem());
            }
            if (downloadItem.getCategory() != Category.PROGRAM && downloadItem.getCategory() != Category.OTHER) {
                this.add(this.createPreviewMenuItem()).setEnabled(downloadItem.isLaunchable());
            }
            this.addSeparator();
            this.add(this.createLocateOnDiskMenuItem());
            this.add(this.createLocateInLibraryMenuItem());
            if (downloadItem.isRelocatable()) {
                this.add(this.createChangeLocactionMenuItem());
            }
            this.addSeparator();
            if (!downloadItem.isStoreDownload()) {
                boolean hasBrowse = this.maybeAddBrowseMenu(downloadItem.getRemoteHosts());
                boolean hasBlock = this.maybeAddBlockMenu(downloadItem.getRemoteHosts());
                if (hasBrowse || hasBlock) {
                    this.addSeparator();
                }
            }
            if (state == DownloadState.ERROR) {
                this.add(this.createCancelWithRemoveNameMenuItem());
            } else {
                this.add(this.createCancelMenuItem());
            }
            this.addSeparator();
            this.add(this.createPropertiesMenuItem());
        }
    }

    private void initializeMultiItemMenu(List<DownloadItem> downloadItems) {
        boolean hasTryAgain = false;
        boolean hasPause = false;
        boolean hasCancel = false;
        boolean hasResume = false;
        boolean allDone = true;
        ArrayList<RemoteHost> hosts = new ArrayList<RemoteHost>();
        for (DownloadItem item : downloadItems) {
            if (hasTryAgain && hasPause && hasCancel && hasResume) break;
            if (item.getState() != DownloadState.DONE && item.getState() != DownloadState.SCAN_FAILED && item.getState() != DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS) {
                allDone = false;
            }
            if (this.isResumable(item.getState())) {
                hasResume = true;
            }
            if (this.isPausable(item.getState())) {
                hasPause = true;
            }
            if (this.isTryAgainable(item.getState())) {
                hasTryAgain = true;
            }
            if (this.isCancelable(item.getState())) {
                hasCancel = true;
            }
            if (item.isStoreDownload()) continue;
            hosts.addAll(item.getRemoteHosts());
        }
        if (allDone) {
            this.add(this.createCancelWithRemoveNameMenuItem());
            this.add(this.listMenuFactory.createAddToListMenu(this.selectedFiles));
        } else {
            if (hasPause) {
                this.add(this.createPauseMenuItem());
            }
            if (hasResume) {
                this.add(this.createResumeMenuItem());
            }
            if (hasTryAgain) {
                this.add(this.createTryAgainMenuItem());
            }
            this.maybeAddBrowseMenu(hosts);
            this.maybeAddBlockMenu(hosts);
            if (hasCancel) {
                this.add(this.createCancelMenuItem());
            }
        }
    }

    private boolean isPausable(DownloadState state) {
        return state.isPausable();
    }

    private boolean isResumable(DownloadState state) {
        return state == DownloadState.PAUSED;
    }

    private boolean isTryAgainable(DownloadState state) {
        return state == DownloadState.STALLED;
    }

    private boolean isCancelable(DownloadState state) {
        return !state.isFinished();
    }

    private boolean maybeAddBrowseMenu(Collection<RemoteHost> remoteHosts) {
        if (remoteHosts.size() > 0) {
            this.add(this.remoteHostMenuFactory.createBrowseMenu(remoteHosts));
            return true;
        }
        return false;
    }

    private boolean maybeAddBlockMenu(Collection<RemoteHost> remoteHosts) {
        JMenu blockMenu = this.blockUserMenuFactory.createDownloadBlockMenu(remoteHosts);
        if (blockMenu != null) {
            this.add(blockMenu);
            return true;
        }
        return false;
    }

    private void cancelEditing() {
        Component comp = this.table.getEditorComponent();
        if (comp != null && comp instanceof TableCellEditor) {
            ((TableCellEditor)((Object)comp)).cancelCellEditing();
        }
    }

    private JMenuItem createPauseMenuItem() {
        JMenuItem pauseMenuItem = new JMenuItem(I18n.tr("Pause"));
        pauseMenuItem.setActionCommand("pause");
        pauseMenuItem.addActionListener(new PauseListener());
        return pauseMenuItem;
    }

    private JMenuItem createCancelMenuItem() {
        JMenuItem cancelMenuItem = new JMenuItem(I18n.tr("Cancel Download"));
        cancelMenuItem.setActionCommand("cancel");
        cancelMenuItem.addActionListener(new CancelListener());
        return cancelMenuItem;
    }

    private JMenuItem createResumeMenuItem() {
        JMenuItem resumeMenuItem = new JMenuItem(I18n.tr("Resume"));
        resumeMenuItem.setActionCommand("resume");
        resumeMenuItem.addActionListener(new ResumeListener());
        return resumeMenuItem;
    }

    private JMenuItem createTryAgainMenuItem() {
        JMenuItem tryAgainMenuItem = new JMenuItem(I18n.tr("Try Again"));
        tryAgainMenuItem.setActionCommand("try again");
        tryAgainMenuItem.addActionListener(new TryAgainListener());
        return tryAgainMenuItem;
    }

    private JMenuItem createLaunchMenuItem() {
        JMenuItem launchMenuItem = new JMenuItem(I18n.tr("Play/Open"));
        launchMenuItem.setActionCommand("launch");
        launchMenuItem.addActionListener(this.menuListener);
        return launchMenuItem;
    }

    private JMenuItem createRemoveMenuItem() {
        JMenuItem removeMenuItem = new JMenuItem(I18n.tr("Clear from Tray"));
        removeMenuItem.setActionCommand("remove");
        removeMenuItem.addActionListener(this.menuListener);
        return removeMenuItem;
    }

    private JMenuItem createCancelWithRemoveNameMenuItem() {
        JMenuItem cancelWithRemoveNameMenuItem = new JMenuItem(I18n.tr("Clear from Tray"));
        cancelWithRemoveNameMenuItem.setActionCommand("cancel");
        cancelWithRemoveNameMenuItem.addActionListener(this.menuListener);
        return cancelWithRemoveNameMenuItem;
    }

    private JMenuItem createLocateOnDiskMenuItem() {
        JMenuItem locateMenuItem = new JMenuItem(I18n.tr("Locate on Disk"));
        locateMenuItem.setActionCommand("locate");
        locateMenuItem.addActionListener(this.menuListener);
        return locateMenuItem;
    }

    private JMenuItem createLocateInLibraryMenuItem() {
        JMenuItem libraryMenuItem = new JMenuItem(I18n.tr("Locate in Library"));
        libraryMenuItem.setActionCommand("library");
        libraryMenuItem.addActionListener(this.menuListener);
        return libraryMenuItem;
    }

    private JMenuItem createPropertiesMenuItem() {
        JMenuItem propertiesMenuItem = new JMenuItem(I18n.tr("View File Info..."));
        propertiesMenuItem.setActionCommand("properties");
        propertiesMenuItem.addActionListener(this.menuListener);
        return propertiesMenuItem;
    }

    private JMenuItem createChangeLocactionMenuItem() {
        JMenuItem changeLocationMenuItem = new JMenuItem(I18n.tr("Change Location..."));
        changeLocationMenuItem.setActionCommand("change location");
        changeLocationMenuItem.addActionListener(this.menuListener);
        return changeLocationMenuItem;
    }

    private JMenuItem createPreviewMenuItem() {
        JMenuItem previewMenuItem = new JMenuItem(I18n.tr("Preview File"));
        previewMenuItem.setActionCommand("preview");
        previewMenuItem.addActionListener(this.menuListener);
        return previewMenuItem;
    }

    private abstract class PopupActionListener
    implements ActionListener {
        private String command;

        public PopupActionListener(String command) {
            this.command = command;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (DownloadItem item : DownloadTableMenu.this.downloadItems) {
                if (!this.isTargetState(item.getState())) continue;
                DownloadTableMenu.this.actionHandler.performAction(this.command, item);
            }
            DownloadTableMenu.this.cancelEditing();
        }

        abstract boolean isTargetState(DownloadState var1);
    }

    private class ResumeListener
    extends PopupActionListener {
        public ResumeListener() {
            super("resume");
        }

        @Override
        boolean isTargetState(DownloadState state) {
            return DownloadTableMenu.this.isResumable(state);
        }
    }

    private class TryAgainListener
    extends PopupActionListener {
        public TryAgainListener() {
            super("try again");
        }

        @Override
        boolean isTargetState(DownloadState state) {
            return DownloadTableMenu.this.isTryAgainable(state);
        }
    }

    private class CancelListener
    extends PopupActionListener {
        public CancelListener() {
            super("cancel");
        }

        @Override
        boolean isTargetState(DownloadState state) {
            return DownloadTableMenu.this.isCancelable(state);
        }
    }

    private class PauseListener
    extends PopupActionListener {
        public PauseListener() {
            super("pause");
        }

        @Override
        boolean isTargetState(DownloadState state) {
            return DownloadTableMenu.this.isPausable(state);
        }
    }

    private class MenuListener
    implements ActionListener {
        private MenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (DownloadItem item : DownloadTableMenu.this.downloadItems) {
                DownloadTableMenu.this.actionHandler.performAction(e.getActionCommand(), item);
            }
            DownloadTableMenu.this.cancelEditing();
        }
    }
}

