/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.swarm.SwarmCoordinator;
import org.limewire.swarm.SwarmSource;
import org.limewire.swarm.SwarmSourceDownloader;
import org.limewire.swarm.SwarmSourceType;
import org.limewire.swarm.Swarmer;
import org.limewire.util.Objects;

public class SwarmerImpl
implements Swarmer {
    private static final Log LOG = LogFactory.getLog(SwarmerImpl.class);
    private final Map<SwarmSourceType, SwarmSourceDownloader> sourceDownloaders;
    private final SwarmCoordinator swarmCoordinator;

    public SwarmerImpl(SwarmCoordinator swarmCoordinator) {
        this.swarmCoordinator = Objects.nonNull(swarmCoordinator, "swarmCoordinator");
        this.sourceDownloaders = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void register(SwarmSourceType type, SwarmSourceDownloader sourceHandler) {
        this.sourceDownloaders.put(type, sourceHandler);
    }

    @Override
    public void addSource(SwarmSource source) {
        SwarmSourceType type = source.getType();
        if (!this.hasDownloaderRegistered(type)) {
            throw new IllegalStateException("No swarm source handler is registered for type: " + (Object)((Object)type));
        }
        SwarmSourceDownloader sourceDownloader = this.sourceDownloaders.get((Object)type);
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Adding source: {0}", (Object)source);
        }
        sourceDownloader.addSource(source);
    }

    @Override
    public void start() {
        for (SwarmSourceDownloader handler : this.sourceDownloaders.values()) {
            try {
                handler.start();
            }
            catch (IOException iox) {
                LOG.warnf("Unable to start swarm source handler: {0}", (Object)handler);
            }
        }
    }

    @Override
    public void shutdown() {
        for (SwarmSourceDownloader handler : this.sourceDownloaders.values()) {
            try {
                handler.shutdown();
            }
            catch (IOException iox) {
                LOG.warnf("Unable to shutdown swarm source handler: {0}", (Object)handler);
            }
        }
        try {
            this.swarmCoordinator.close();
        }
        catch (IOException iox) {
            LOG.warnf("Unable to shutdown swarm coordinator: {0}", (Object)this.swarmCoordinator);
        }
    }

    @Override
    public float getMeasuredBandwidth(boolean downstream) {
        float bandwidth = 0.0f;
        for (SwarmSourceDownloader handler : this.sourceDownloaders.values()) {
            bandwidth += handler.getMeasuredBandwidth(downstream);
        }
        return bandwidth;
    }

    @Override
    public boolean hasDownloaderRegistered(SwarmSourceType type) {
        return this.sourceDownloaders.containsKey((Object)type);
    }

    @Override
    public SwarmCoordinator getCoordinator() {
        return this.swarmCoordinator;
    }
}

