/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.RequiresSelectionKeyAttachment;
import org.limewire.nio.Throttle;
import org.limewire.nio.ThrottleListener;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;

public class ThrottleWriter
implements ChannelWriter,
InterestWritableByteChannel,
RequiresSelectionKeyAttachment {
    private volatile InterestWritableByteChannel channel;
    private volatile WriteObserver observer;
    private volatile Throttle throttle;
    private int available;
    private boolean channelInterested;
    private final Listener throttleListener;

    public ThrottleWriter(Throttle throttle) {
        this(throttle, null);
    }

    public ThrottleWriter(Throttle throttle, InterestWritableByteChannel channel) {
        this.throttle = throttle;
        this.channel = channel;
        this.throttleListener = new Listener();
    }

    @Override
    public InterestWritableByteChannel getWriteChannel() {
        return this.channel;
    }

    @Override
    public void setWriteChannel(InterestWritableByteChannel channel) {
        this.channel = channel;
        Throttle t = this.throttle;
        if (t != null) {
            t.interest(this.throttleListener);
        } else if (channel != null) {
            channel.interestWrite(this, true);
        }
    }

    @Override
    public void interestWrite(WriteObserver observer, boolean status) {
        if (status) {
            this.observer = observer;
            if (this.channel != null) {
                Throttle t = this.throttle;
                if (t != null) {
                    t.interest(this.throttleListener);
                } else {
                    this.channel.interestWrite(this, status);
                }
            }
        } else {
            this.observer = null;
        }
    }

    @Override
    public int write(ByteBuffer buffer) throws IOException {
        InterestWritableByteChannel chain = this.channel;
        if (chain == null) {
            throw new IllegalStateException("writing with no chain!");
        }
        if (this.throttle == null) {
            return chain.write(buffer);
        }
        if (this.available == 0) {
            return 0;
        }
        int priorLimit = buffer.limit();
        if (buffer.remaining() > this.available) {
            buffer.limit(buffer.position() + this.available);
        }
        int totalWrote = this.channel.write(buffer);
        this.available -= totalWrote;
        buffer.limit(priorLimit);
        return totalWrote;
    }

    @Override
    public void close() throws IOException {
        InterestWritableByteChannel source = this.channel;
        if (source != null) {
            source.close();
        }
    }

    @Override
    public boolean isOpen() {
        InterestWritableByteChannel source = this.channel;
        return source != null ? source.isOpen() : false;
    }

    @Override
    public boolean handleWrite() throws IOException {
        InterestWritableByteChannel chain = this.channel;
        if (chain == null) {
            throw new IllegalStateException("writing with no source.");
        }
        WriteObserver interested = this.observer;
        chain.interestWrite(this, false);
        this.channelInterested = false;
        if (this.available > 0 || this.throttle == null) {
            if (interested != null) {
                interested.handleWrite();
            }
            interested = this.observer;
        }
        if (interested != null) {
            if (this.throttle != null) {
                this.throttle.interest(this.throttleListener);
            } else {
                chain.interestWrite(this, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void shutdown() {
        WriteObserver listener = this.observer;
        if (listener != null) {
            listener.shutdown();
        }
    }

    @Override
    public void handleIOException(IOException x) {
        throw new RuntimeException("Unsupported", x);
    }

    @Override
    public boolean hasBufferedOutput() {
        InterestWritableByteChannel channel = this.channel;
        return channel != null && channel.hasBufferedOutput();
    }

    public void setThrottle(final Throttle throttle) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                ThrottleWriter.this.setThrottleInternal(throttle);
            }
        });
    }

    protected void setThrottleInternal(Throttle throttle) {
        this.throttleListener.releaseBandwidth();
        this.throttle = throttle;
        if (throttle != null) {
            throttle.interest(this.throttleListener);
        } else if (this.channel != null) {
            this.channel.interestWrite(this, true);
        }
    }

    @Override
    public void setAttachment(Object o) {
        this.throttleListener.setAttachment(o);
    }

    private final class Listener
    implements ThrottleListener {
        private Object attachment;

        private Listener() {
        }

        @Override
        public boolean bandwidthAvailable() {
            if (ThrottleWriter.this.channel.isOpen()) {
                if (!ThrottleWriter.this.channelInterested) {
                    ThrottleWriter.this.channelInterested = true;
                    ThrottleWriter.this.channel.interestWrite(ThrottleWriter.this, true);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean isOpen() {
            return ThrottleWriter.this.isOpen();
        }

        @Override
        public void requestBandwidth() {
            if (ThrottleWriter.this.throttle != null) {
                ThrottleWriter.this.available = ThrottleWriter.this.throttle.request();
            }
        }

        @Override
        public void releaseBandwidth() {
            if (ThrottleWriter.this.throttle != null) {
                ThrottleWriter.this.throttle.release(ThrottleWriter.this.available);
                ThrottleWriter.this.available = 0;
            }
        }

        public void setAttachment(Object att) {
            this.attachment = att;
        }

        @Override
        public Object getAttachment() {
            return this.attachment;
        }
    }
}

