/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.limewire.collection.IntHashMap;

public class HeapByteBufferCache {
    private static final int MAX_SIZE = 0x100000;
    private final IntHashMap<List<ByteBuffer>> CACHE = new IntHashMap();
    private long totalCacheSize;

    public ByteBuffer get() {
        return this.get(8192);
    }

    public synchronized ByteBuffer get(int size) {
        if (this.CACHE.isEmpty()) {
            ByteBuffer buf = ByteBuffer.allocate(size);
            return buf;
        }
        List<ByteBuffer> l = this.CACHE.get(size);
        if (l != null && !l.isEmpty()) {
            ByteBuffer buf = l.remove(l.size() - 1);
            this.totalCacheSize -= (long)buf.capacity();
            return buf;
        }
        return ByteBuffer.allocate(size);
    }

    public synchronized void put(ByteBuffer toReturn) {
        if (this.totalCacheSize > 0x100000L) {
            return;
        }
        int size = toReturn.capacity();
        toReturn.clear();
        List<ByteBuffer> l = this.CACHE.get(size);
        if (l == null) {
            l = new ArrayList<ByteBuffer>(1);
            this.CACHE.put(size, l);
        }
        l.add(toReturn);
        this.totalCacheSize += (long)toReturn.capacity();
    }

    public synchronized void clear() {
        this.CACHE.clear();
        this.totalCacheSize = 0L;
    }

    public synchronized long getByteSize() {
        return this.totalCacheSize;
    }
}

