/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

public class BandwidthThrottle {
    private static final int TICKS_PER_SECOND = 10;
    private static final int MILLIS_PER_TICK = 100;
    private volatile int _bytesPerTick;
    private volatile boolean _switching = false;
    private int _availableBytes;
    private long _nextTickTime;

    public BandwidthThrottle(float bytesPerSecond) {
        this.setRate(bytesPerSecond);
    }

    public BandwidthThrottle(float bytesPerSecond, boolean switching) {
        this.setRate(bytesPerSecond);
        this.setSwitching(switching);
    }

    public void setRate(float bytesPerSecond) {
        this._bytesPerTick = (int)(bytesPerSecond / 10.0f);
        if (this._switching) {
            this.fixBytesPerTick(true);
        }
    }

    public void setSwitching(boolean switching) {
        if (this._switching != switching) {
            this.fixBytesPerTick(switching);
        }
        this._switching = switching;
    }

    private void fixBytesPerTick(boolean raise) {
        int newBytesPerTick = this._bytesPerTick;
        newBytesPerTick = raise ? (newBytesPerTick *= 2) : (newBytesPerTick /= 2);
        if (newBytesPerTick < 0) {
            newBytesPerTick = Integer.MAX_VALUE;
        }
        this._bytesPerTick = newBytesPerTick;
    }

    public synchronized int request(int desired) {
        this.waitForBandwidth();
        int result = Math.min(desired, this._availableBytes);
        this._availableBytes -= result;
        return result;
    }

    private void waitForBandwidth() {
        while (true) {
            long now = System.currentTimeMillis();
            this.updateWindow(now);
            if (this._availableBytes != 0) break;
            try {
                Thread.sleep(this._nextTickTime - now);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void updateWindow(long now) {
        if (now >= this._nextTickTime) {
            if (!this._switching || now / 1000L % 2L == 0L) {
                this._availableBytes = this._bytesPerTick;
                this._nextTickTime = now + 100L;
            } else {
                this._availableBytes = 0;
                long diff = 1000L - now % 1000L;
                this._nextTickTime = now + diff;
            }
        }
    }
}

