/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.URN;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;

public class ResourceLocationCounter {
    private final long _fileSize;
    private final IntervalSet _psets = new IntervalSet();
    private int _wholeCount = 0;
    private int _displayCount = 0;
    private int _partialCount = 0;
    private float _percentAvailable = 0.0f;

    public ResourceLocationCounter(URN urn, long fileSize) {
        if (fileSize < 0L) {
            throw new IllegalArgumentException("fileSize may not be negative: " + fileSize);
        }
        this._fileSize = fileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartialSource(IntervalSet is) {
        ResourceLocationCounter resourceLocationCounter = this;
        synchronized (resourceLocationCounter) {
            this._psets.add(is);
        }
        this.calculateLocationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementWholeSources() {
        ResourceLocationCounter resourceLocationCounter = this;
        synchronized (resourceLocationCounter) {
            ++this._wholeCount;
            this._percentAvailable = 100.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisplayLocationCount(int num) {
        ResourceLocationCounter resourceLocationCounter = this;
        synchronized (resourceLocationCounter) {
            this._displayCount += num;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLocationCount() {
        ResourceLocationCounter resourceLocationCounter = this;
        synchronized (resourceLocationCounter) {
            return this._wholeCount + this._partialCount;
        }
    }

    public int getDisplayLocationCount() {
        return this._displayCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPercentAvailable() {
        ResourceLocationCounter resourceLocationCounter = this;
        synchronized (resourceLocationCounter) {
            return this._percentAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateLocationCount() {
        ResourceLocationCounter resourceLocationCounter = this;
        synchronized (resourceLocationCounter) {
            long sum = 0L;
            if (this._psets.getNumberOfIntervals() == 0) {
                this._partialCount = 0;
                this._percentAvailable = this._wholeCount > 0 ? 100.0f : 0.0f;
                return;
            }
            if (this._psets.contains(Range.createRange(0L, this._fileSize - 1L))) {
                this._partialCount = 1;
                this._percentAvailable = 100.0f;
                return;
            }
            for (Range range : this._psets.getAllIntervalsAsList()) {
                sum += range.getHigh() - range.getLow() + 1L;
            }
            this._partialCount = 0;
            this._percentAvailable = sum > 0L ? (float)sum * 100.0f / (float)this._fileSize : 0.0f;
        }
    }
}

