/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.impl.StreamWriterBase;

public class ISO88591StreamWriter
extends StreamWriterBase {
    public ISO88591StreamWriter(String[] stringArray) {
        super("ISO-8859-1", stringArray);
        this.m_prefixBytes = new byte[stringArray.length][];
        try {
            this.defineNamespace(0, "");
            this.defineNamespace(1, "xml");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public ISO88591StreamWriter(ISO88591StreamWriter iSO88591StreamWriter, String[] stringArray) {
        super(iSO88591StreamWriter, stringArray);
        this.m_prefixBytes = new byte[stringArray.length][];
        try {
            this.defineNamespace(0, "");
            this.defineNamespace(1, "xml");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    protected void writeMarkup(String string) throws IOException {
        int n = string.length();
        this.makeSpace(n);
        int n2 = this.m_fillOffset;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c > '\u00ff') {
                throw new IOException("Unable to write character code 0x" + Integer.toHexString(c) + " in encoding ISO-8859-1");
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = n2;
    }

    protected void writeMarkup(char c) throws IOException {
        this.makeSpace(1);
        if (c > '\u00ff') {
            throw new IOException("Unable to write character code 0x" + Integer.toHexString(c) + " in encoding ISO-8859-1");
        }
        this.m_buffer[this.m_fillOffset++] = (byte)c;
    }

    protected void defineNamespace(int n, String string) throws IOException {
        int n2;
        int n3;
        byte[] byArray = new byte[string.length()];
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n2 = string.charAt(n3);
            if (n2 > 255) {
                throw new IOException("Unable to write character code 0x" + Integer.toHexString(n2) + " in encoding ISO-8859-1");
            }
            byArray[n3] = (byte)n2;
        }
        if (n < this.m_prefixBytes.length) {
            this.m_prefixBytes[n] = byArray;
        } else if (this.m_extensionBytes != null) {
            n -= this.m_prefixBytes.length;
            for (n3 = 0; n3 < this.m_extensionBytes.length; ++n3) {
                n2 = this.m_extensionBytes[n3].length;
                if (n < n2) {
                    this.m_extensionBytes[n3][n] = byArray;
                    continue;
                }
                n -= n2;
            }
        } else {
            throw new IllegalArgumentException("Index out of range");
        }
    }

    protected void writeAttributeText(String string) throws IOException {
        int n = string.length();
        this.makeSpace(n);
        int n2 = this.m_fillOffset;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                n2 = this.writeEntity(QUOT_ENTITY, n2);
                continue;
            }
            if (c == '&') {
                n2 = this.writeEntity(AMP_ENTITY, n2);
                continue;
            }
            if (c == '<') {
                n2 = this.writeEntity(LT_ENTITY, n2);
                continue;
            }
            if (c == '>' && i > 2 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                this.m_buffer[n2++] = 93;
                this.m_buffer[n2++] = 93;
                n2 = this.writeEntity(GT_ENTITY, n2);
                continue;
            }
            if (c < ' ') {
                if (c != '\t' && c != '\n' && c != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in attribute value text");
                }
                this.m_buffer[n2++] = (byte)c;
                continue;
            }
            if (c > '\u00ff') {
                if (c > '\ud7ff' && (c < '\ue000' || c == '\ufffe' || c == '\uffff' || c > '\u10ffff')) {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in attribute value text");
                }
                this.m_fillOffset = n2;
                this.makeSpace(n - i + 8);
                n2 = this.m_fillOffset;
                this.m_buffer[n2++] = 38;
                this.m_buffer[n2++] = 35;
                this.m_buffer[n2++] = 120;
                for (int j = 12; j >= 0; j -= 4) {
                    int n3 = c >> j & 0xF;
                    this.m_buffer[n2++] = n3 < 10 ? (byte)(48 + n3) : (byte)(65 + n3);
                }
                this.m_buffer[n2++] = 59;
                continue;
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = n2;
    }

    public void writeTextContent(String string) throws IOException {
        int n = string.length();
        this.makeSpace(n);
        int n2 = this.m_fillOffset;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                n2 = this.writeEntity(AMP_ENTITY, n2);
                continue;
            }
            if (c == '<') {
                n2 = this.writeEntity(LT_ENTITY, n2);
                continue;
            }
            if (c == '>' && i > 2 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                this.m_buffer[n2++] = 93;
                this.m_buffer[n2++] = 93;
                n2 = this.writeEntity(GT_ENTITY, n2);
                continue;
            }
            if (c < ' ') {
                if (c != '\t' && c != '\n' && c != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in content text");
                }
                this.m_buffer[n2++] = (byte)c;
                continue;
            }
            if (c > '\u00ff') {
                if (c > '\ud7ff' && (c < '\ue000' || c == '\ufffe' || c == '\uffff' || c > '\u10ffff')) {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in character data text");
                }
                this.m_fillOffset = n2;
                this.makeSpace(n - i + 8);
                n2 = this.m_fillOffset;
                this.m_buffer[n2++] = 38;
                this.m_buffer[n2++] = 35;
                this.m_buffer[n2++] = 120;
                for (int j = 12; j >= 0; j -= 4) {
                    int n3 = c >> j & 0xF;
                    this.m_buffer[n2++] = n3 < 10 ? (byte)(48 + n3) : (byte)(65 + n3);
                }
                this.m_buffer[n2++] = 59;
                continue;
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = n2;
        this.m_contentSeen = true;
        this.m_textSeen = true;
    }

    public void writeCData(String string) throws IOException {
        int n = string.length();
        this.makeSpace(n + 12);
        int n2 = this.m_fillOffset;
        n2 = this.writeEntity(LT_CDATASTART, n2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '>' && i > 2 && string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']') {
                throw new IOException("Sequence \"]]>\" is not allowed within CDATA section text");
            }
            if (c < ' ') {
                if (c != '\t' && c != '\n' && c != '\r') {
                    throw new IOException("Illegal character code 0x" + Integer.toHexString(c) + " in content text");
                }
                this.m_buffer[n2++] = (byte)c;
                continue;
            }
            if (c > '\u00ff') {
                throw new IOException("Character code 0x" + Integer.toHexString(c) + " not allowed by encoding in CDATA section text");
            }
            this.m_buffer[n2++] = (byte)c;
        }
        this.m_fillOffset = this.writeEntity(LT_CDATAEND, n2);
        this.m_contentSeen = true;
        this.m_textSeen = true;
    }

    public IXMLWriter createChildWriter(String[] stringArray) {
        return new ISO88591StreamWriter(this, stringArray);
    }
}

