/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.schememode;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.modes.MapAdapter;
import freemind.modes.ModeController;
import freemind.modes.schememode.SchemeNodeModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.net.URL;

public class SchemeMapModel
extends MapAdapter {
    public SchemeMapModel(FreeMindMain frame, ModeController modeController) {
        super(frame, modeController);
        this.setRoot(new SchemeNodeModel(this.getFrame(), this));
    }

    public boolean save(File file) {
        try {
            this.setFile(file);
            this.setSaved(true);
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            fileout.write(this.getCode());
            fileout.close();
            return true;
        }
        catch (Exception e) {
            System.err.println("Error in SchemeMapModel.save: ");
            Resources.getInstance().logException(e);
            return false;
        }
    }

    public void load(URL url) throws FileNotFoundException {
        File file = new File(url.getFile());
        this.setFile(file);
        this.setRoot(new SchemeNodeModel(this.getFrame(), this));
        try {
            this.loadMathStyle(new InputStreamReader(new FileInputStream(file)));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadMathStyle(Reader re) throws IOException {
        StreamTokenizer tok = new StreamTokenizer(re);
        tok.resetSyntax();
        tok.whitespaceChars(0, 32);
        tok.wordChars(33, 255);
        tok.ordinaryChars(40, 41);
        tok.commentChar(59);
        SchemeNodeModel node = (SchemeNodeModel)this.getRoot();
        while (tok.nextToken() != -1) {
            if (tok.ttype == 40) {
                SchemeNodeModel newNode = new SchemeNodeModel(this.getFrame(), this);
                this.insertNodeInto(newNode, node, node.getChildCount());
                node = newNode;
                continue;
            }
            if (tok.ttype == 41) {
                if (node.getParent() == null) continue;
                node = (SchemeNodeModel)node.getParent();
                continue;
            }
            if (tok.ttype != -3) continue;
            String token = tok.sval.trim();
            if (node.toString().equals(" ") && node.getChildCount() == 0) {
                node.setUserObject(token);
                continue;
            }
            SchemeNodeModel newNode = new SchemeNodeModel(this.getFrame(), this);
            this.insertNodeInto(newNode, node, node.getChildCount());
            newNode.setUserObject(token);
        }
    }

    public String getCode() {
        return ((SchemeNodeModel)this.getRoot()).getCodeMathStyle();
    }

    public String toString() {
        if (this.getFile() == null) {
            return null;
        }
        return this.getFile().getName();
    }

    public void getXml(Writer fileout) throws IOException {
        fileout.write(this.getCode());
    }

    public void getFilteredXml(Writer fileout) throws IOException {
        throw new RuntimeException("Unimplemented method called.");
    }
}

