/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.controller.Controller;
import freemind.controller.MenuBar;
import freemind.view.mindmapview.MapView;
import java.awt.Container;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JSplitPane;

public interface FreeMindMain {
    public static final int VERSION_TYPE_ALPHA = 0;
    public static final int VERSION_TYPE_BETA = 1;
    public static final int VERSION_TYPE_RC = 2;
    public static final int VERSION_TYPE_RELEASE = 3;

    public JFrame getJFrame();

    public boolean isApplet();

    public MapView getView();

    public void setView(MapView var1);

    public Controller getController();

    public void setWaitingCursor(boolean var1);

    public File getPatternsFile();

    public MenuBar getFreeMindMenuBar();

    public ResourceBundle getResources();

    public String getResourceString(String var1);

    public String getResourceString(String var1, String var2);

    public Container getContentPane();

    public void out(String var1);

    public void err(String var1);

    public void openDocument(URL var1) throws Exception;

    public void repaint();

    public URL getResource(String var1);

    public int getIntProperty(String var1, int var2);

    public Properties getProperties();

    public String getProperty(String var1);

    public void setProperty(String var1, String var2);

    public void saveProperties();

    public String getFreemindDirectory();

    public JLayeredPane getLayeredPane();

    public Container getViewport();

    public void setTitle(String var1);

    public int getWinHeight();

    public int getWinWidth();

    public int getWinState();

    public int getWinX();

    public int getWinY();

    public VersionInformation getFreemindVersion();

    public Logger getLogger(String var1);

    public JSplitPane insertComponentIntoSplitPane(JComponent var1);

    public void removeSplitPane();

    public ClassLoader getFreeMindClassLoader();

    public String getFreemindBaseDir();

    public String getAdjustableProperty(String var1);

    public void setDefaultProperty(String var1, String var2);

    public static class VersionInformation {
        public int mMaj = 0;
        public int mMid = 9;
        public int mMin = 0;
        public int mType = 1;
        public int mNum = 17;

        public VersionInformation(int pMaj, int pMid, int pMin, int pType, int pNum) {
            this.mMaj = pMaj;
            this.mMid = pMid;
            this.mMin = pMin;
            this.mType = pType;
            this.mNum = pNum;
        }

        public VersionInformation(String pString) {
            StringTokenizer t = new StringTokenizer(pString, ". ", false);
            String[] info = new String[t.countTokens()];
            int i = 0;
            while (t.hasMoreTokens()) {
                info[i++] = t.nextToken();
            }
            if (info.length != 3 && info.length != 5) {
                throw new IllegalArgumentException("Wrong number of tokens for version information: " + pString);
            }
            this.mMaj = Integer.parseInt(info[0]);
            this.mMid = Integer.parseInt(info[1]);
            this.mMin = Integer.parseInt(info[2]);
            if (info.length == 3) {
                this.mType = 3;
                this.mNum = 0;
                return;
            }
            Vector<String> types = new Vector<String>();
            types.add("Alpha");
            types.add("Beta");
            types.add("RC");
            int typeIndex = types.indexOf(info[3]);
            if (typeIndex < 0) {
                throw new IllegalArgumentException("Wrong version type for version information: " + info[4]);
            }
            this.mType = typeIndex;
            this.mNum = Integer.parseInt(info[4]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(this.mMaj);
            buf.append('.');
            buf.append(this.mMid);
            buf.append('.');
            buf.append(this.mMin);
            switch (this.mType) {
                case 0: {
                    buf.append(' ');
                    buf.append("Alpha");
                    break;
                }
                case 1: {
                    buf.append(' ');
                    buf.append("Beta");
                    break;
                }
                case 2: {
                    buf.append(' ');
                    buf.append("RC");
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown version type " + this.mType);
                }
            }
            if (this.mType != 3) {
                buf.append(' ');
                buf.append(this.mNum);
            }
            return buf.toString();
        }
    }
}

