/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.limewire.ui.swing.table.GlazedJXTable;

public class StripedJXTable
extends GlazedJXTable {
    private boolean emptyRowsPainted = true;

    public StripedJXTable() {
    }

    public StripedJXTable(TableModel tableModel) {
        super(tableModel);
    }

    public StripedJXTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
    }

    public StripedJXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public void setEmptyRowsPainted(boolean painted) {
        this.emptyRowsPainted = painted;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.emptyRowsPainted) {
            this.paintEmptyRows(g);
        }
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int clipHeight = clip.y + clip.height;
        int tableHeight = this.getVisibleRect().height;
        int clipViewableRows = clipHeight / this.rowHeight;
        int tableViewableRows = tableHeight / this.rowHeight;
        int startDrawingAt = rowCount * this.rowHeight;
        if (startDrawingAt < tableHeight) {
            if (clipViewableRows < tableViewableRows) {
                this.repaint(clip.x, startDrawingAt, clip.width, tableHeight - startDrawingAt);
            } else {
                for (int i = rowCount; i <= clipViewableRows; ++i) {
                    g.setColor(this.getColorForRow(i));
                    g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
                    if (!this.getShowHorizontalLines() || i <= rowCount) continue;
                    g.setColor(this.gridColor);
                    g.drawLine(clip.x, i * this.rowHeight, clip.x + clip.width, i * this.rowHeight);
                }
                if (this.getShowVerticalLines()) {
                    g.setColor(this.gridColor);
                    TableColumnModel columnModel = this.getColumnModel();
                    int x = 0;
                    for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                        TableColumn column = columnModel.getColumn(i);
                        g.drawLine((x += column.getWidth()) - 1, rowCount * this.rowHeight, x - 1, rowCount * this.rowHeight + clipHeight);
                    }
                }
            }
        }
    }

    protected Color getColorForRow(int row) {
        return row % 2 == 0 ? this.getHighlighterColor(0) : this.getHighlighterColor(1);
    }

    private Color getHighlighterColor(int index) {
        if (this.getHighlighters() == null || this.getHighlighters().length == 0) {
            return this.getBackground();
        }
        if (this.getHighlighters()[0] instanceof CompoundHighlighter) {
            if (((CompoundHighlighter)this.getHighlighters()[0]).getHighlighters().length <= index) {
                return this.getBackground();
            }
            return ((ColorHighlighter)((CompoundHighlighter)this.getHighlighters()[0]).getHighlighters()[index]).getBackground();
        }
        if (this.getHighlighters()[0] instanceof ColorHighlighter) {
            if (this.getHighlighters().length <= index) {
                return this.getBackground();
            }
            return ((ColorHighlighter)this.getHighlighters()[index]).getBackground();
        }
        return this.getBackground();
    }
}

