/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.table;

import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.SizeSequence;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.SizeSequenceMapper;
import org.jdesktop.swingx.decorator.SortController;
import org.limewire.ui.swing.table.BasicJXTable;

public class GlazedJXTable
extends BasicJXTable {
    private SizeSequenceMapper simpleRowModelMapper;
    private SelectionMapper simpleSelectionMapper;
    private SortController sortController;
    private boolean inTableChangeRowHeightHack;

    public GlazedJXTable() {
        this.initialize();
    }

    public GlazedJXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initialize();
    }

    public GlazedJXTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public GlazedJXTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initialize();
    }

    public GlazedJXTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initialize();
    }

    public GlazedJXTable(TableModel dm) {
        super(dm);
        this.initialize();
    }

    public GlazedJXTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    private void initialize() {
    }

    @Override
    public boolean isRowHeightEnabled() {
        if (this.inTableChangeRowHeightHack) {
            return false;
        }
        return super.isRowHeightEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableChanged(TableModelEvent e) {
        this.inTableChangeRowHeightHack = true;
        try {
            super.tableChanged(e);
        }
        finally {
            this.inTableChangeRowHeightHack = false;
        }
    }

    @Override
    protected SizeSequenceMapper getRowModelMapper() {
        if (this.simpleRowModelMapper == null) {
            this.simpleRowModelMapper = new SimpleSizeSequenceMapper();
        }
        return this.simpleRowModelMapper;
    }

    @Override
    public SelectionMapper getSelectionMapper() {
        if (this.simpleSelectionMapper == null) {
            this.simpleSelectionMapper = new SimpleSelectionMapper();
        }
        return this.simpleSelectionMapper;
    }

    @Override
    protected boolean shouldSortOnChange(TableModelEvent e) {
        return false;
    }

    @Override
    public void setFilters(FilterPipeline pipeline) {
        if (pipeline != null) {
            throw new UnsupportedOperationException("do not use filters.");
        }
    }

    @Override
    public FilterPipeline getFilters() {
        return null;
    }

    @Override
    public SortController getSortController() {
        return this.sortController;
    }

    public void setSortController(SortController sortController) {
        this.sortController = sortController;
    }

    private static class SimpleSelectionMapper
    implements SelectionMapper {
        private SimpleSelectionMapper() {
        }

        @Override
        public ListSelectionModel getViewSelectionModel() {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void setViewSelectionModel(ListSelectionModel viewSelectionModel) {
        }

        @Override
        public void setFilters(FilterPipeline pipeline) {
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public void clearModelSelection() {
        }

        @Override
        public void insertIndexInterval(int start, int length, boolean before) {
        }

        @Override
        public void removeIndexInterval(int start, int end) {
        }
    }

    private static class SimpleSizeSequenceMapper
    extends SizeSequenceMapper {
        private SimpleSizeSequenceMapper() {
        }

        @Override
        public void setViewSizeSequence(SizeSequence selection, int height) {
        }

        @Override
        public SizeSequence getViewSizeSequence() {
            return null;
        }

        @Override
        public void setFilters(FilterPipeline pipeline) {
        }

        @Override
        public void clearModelSizes() {
        }

        @Override
        public void insertIndexInterval(int start, int length, int value) {
        }

        @Override
        public void removeIndexInterval(int start, int length) {
        }

        @Override
        public void restoreSelection() {
        }

        @Override
        protected void updateFromPipelineChanged() {
        }
    }
}

