/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Collection;
import java.util.Comparator;
import org.limewire.collection.SortedList;

public class FixedSizeSortedList<E>
extends SortedList<E> {
    private final int capacity;

    public FixedSizeSortedList(int capacity) {
        this.capacity = capacity;
    }

    public FixedSizeSortedList(Collection<? extends E> c, Comparator<? super E> comparator, int capacity) {
        super(c, comparator);
        this.capacity = capacity;
    }

    public FixedSizeSortedList(Collection<? extends E> c, int capacity) {
        super(c);
        this.capacity = capacity;
    }

    public FixedSizeSortedList(Comparator<? super E> comparator, int capacity) {
        super(comparator);
        this.capacity = capacity;
    }

    @Override
    public boolean add(E e) {
        if (this.size() == this.capacity) {
            this.remove(this.last());
        }
        return super.add(e);
    }

    public E insert(E e) {
        Object ret = null;
        if (this.size() == this.capacity) {
            ret = this.last();
            if (this.comparator().compare(e, ret) < 0) {
                return e;
            }
            this.remove(ret);
        }
        this.add(e);
        return (E)ret;
    }
}

