/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfExtendedHeader;
import org.jaudiotagger.audio.asf.data.AudioStreamChunk;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ChunkContainer;
import org.jaudiotagger.audio.asf.data.ContentDescription;
import org.jaudiotagger.audio.asf.data.EncodingChunk;
import org.jaudiotagger.audio.asf.data.EncryptionChunk;
import org.jaudiotagger.audio.asf.data.ExtendedContentDescription;
import org.jaudiotagger.audio.asf.data.FileHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamBitratePropertiesChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public final class AsfHeader
extends ChunkContainer {
    public static final Charset ASF_CHARSET = Charset.forName("UTF-16LE");
    private static final HashSet<GUID> MULTI_CHUNKS;
    public static final byte[] ZERO_TERM;
    private final long chunkCount;

    public AsfHeader(long pos, BigInteger chunkLen, long chunkCnt) {
        super(GUID.GUID_HEADER, pos, chunkLen);
        this.chunkCount = chunkCnt;
    }

    public ContentDescription findContentDescription() {
        ContentDescription result = this.getContentDescription();
        if (result == null && this.getExtendedHeader() != null) {
            result = this.getExtendedHeader().getContentDescription();
        }
        return result;
    }

    public ExtendedContentDescription findExtendedContentDescription() {
        ExtendedContentDescription result = this.getExtendedContentDescription();
        if (result == null && this.getExtendedHeader() != null) {
            result = this.getExtendedHeader().getExtendedContentDescription();
        }
        return result;
    }

    public AudioStreamChunk getAudioStreamChunk() {
        AudioStreamChunk result = null;
        List<Chunk> streamChunks = this.assertChunkList(GUID.GUID_STREAM);
        for (int i = 0; i < streamChunks.size() && result == null; ++i) {
            if (!(streamChunks.get(i) instanceof AudioStreamChunk)) continue;
            result = (AudioStreamChunk)streamChunks.get(i);
        }
        return result;
    }

    public long getChunkCount() {
        return this.chunkCount;
    }

    public ContentDescription getContentDescription() {
        return (ContentDescription)this.getFirst(GUID.GUID_CONTENTDESCRIPTION, ContentDescription.class);
    }

    public EncodingChunk getEncodingChunk() {
        return (EncodingChunk)this.getFirst(GUID.GUID_ENCODING, EncodingChunk.class);
    }

    public EncryptionChunk getEncryptionChunk() {
        return (EncryptionChunk)this.getFirst(GUID.GUID_CONTENT_ENCRYPTION, EncryptionChunk.class);
    }

    public ExtendedContentDescription getExtendedContentDescription() {
        return (ExtendedContentDescription)this.getFirst(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, ExtendedContentDescription.class);
    }

    public AsfExtendedHeader getExtendedHeader() {
        return (AsfExtendedHeader)this.getFirst(GUID.GUID_HEADER_EXTENSION, AsfExtendedHeader.class);
    }

    public FileHeader getFileHeader() {
        return (FileHeader)this.getFirst(GUID.GUID_FILE, FileHeader.class);
    }

    public StreamBitratePropertiesChunk getStreamBitratePropertiesChunk() {
        return (StreamBitratePropertiesChunk)this.getFirst(GUID.GUID_STREAM_BITRATE_PROPERTIES, StreamBitratePropertiesChunk.class);
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuffer result = new StringBuffer(super.prettyPrint(prefix, prefix + "  | : Contains: \"" + this.getChunkCount() + "\" chunks" + Utils.LINE_SEPARATOR));
        return result.toString();
    }

    static {
        ZERO_TERM = new byte[]{0, 0};
        MULTI_CHUNKS = new HashSet();
        MULTI_CHUNKS.add(GUID.GUID_STREAM);
    }
}

