/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.security.Certificate;
import com.limegroup.gnutella.security.CertificateParserImpl;
import com.limegroup.gnutella.security.CertifiedMessageVerifier;
import com.limegroup.gnutella.version.DownloadInformation;
import com.limegroup.gnutella.version.OS;
import com.limegroup.gnutella.version.UpdateCollection;
import com.limegroup.gnutella.version.UpdateData;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.http.httpclient.HttpClientInstanceUtils;
import org.limewire.io.InvalidDataException;
import org.limewire.util.Base32;
import org.limewire.util.StringUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;
import org.limewire.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateCollectionImpl
implements UpdateCollection {
    private static final Log LOG = LogFactory.getLog(UpdateCollectionImpl.class);
    private int collectionId = Integer.MIN_VALUE;
    private long collectionTimestamp = -1L;
    private final List<UpdateData> updateDataList;
    private List<DownloadInformation> downloadDataList = new LinkedList<DownloadInformation>();
    private int keyVersion = -1;
    private int newVersion = -1;
    private byte[] signature;
    private byte[] signedPayload;
    private Certificate certificate;
    private final HttpClientInstanceUtils httpClientInstanceUtils;

    public UpdateCollectionImpl(String xml, HttpClientInstanceUtils httpClientInstanceUtils) throws InvalidDataException {
        this.httpClientInstanceUtils = httpClientInstanceUtils;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Parsing Update XML: " + xml);
        }
        ArrayList<UpdateData> updateData = new ArrayList<UpdateData>();
        this.parse(xml, updateData);
        this.updateDataList = Collections.unmodifiableList(updateData);
    }

    public String toString() {
        return "Update Collection, id: " + this.collectionId + ", timestamp: " + this.collectionTimestamp + ", data: " + this.updateDataList;
    }

    @Override
    public int getId() {
        return this.collectionId;
    }

    @Override
    public long getTimestamp() {
        return this.collectionTimestamp;
    }

    @Override
    public List<UpdateData> getUpdateData() {
        return this.updateDataList;
    }

    @Override
    public List<DownloadInformation> getUpdatesWithDownloadInformation() {
        return Collections.unmodifiableList(this.downloadDataList);
    }

    @Override
    public UpdateData getUpdateDataFor(Version currentV, String lang, boolean currentPro, int currentStyle, Version currentJava) {
        UpdateData englishMatch = null;
        UpdateData exactMatch = null;
        for (UpdateData next : this.updateDataList) {
            if (!next.isAllowed(currentV, currentPro, currentStyle, currentJava)) continue;
            if (lang.equals(next.getLanguage())) {
                exactMatch = next;
                break;
            }
            if (!"en".equals(next.getLanguage()) || englishMatch != null) continue;
            englishMatch = next;
        }
        if (exactMatch == null) {
            return englishMatch;
        }
        return exactMatch;
    }

    private void parse(String xml, List<UpdateData> updateDataList) throws InvalidDataException {
        Document d;
        try {
            d = XMLUtils.getDocument(xml, LOG);
        }
        catch (IOException ioe) {
            LOG.error("Unable to parse: " + xml, ioe);
            throw new InvalidDataException(ioe);
        }
        this.parseDocumentElement(d.getDocumentElement(), updateDataList, xml);
    }

    private void parseDocumentElement(Node doc, List<UpdateData> updateDataList, String xml) throws InvalidDataException {
        if (!"update".equals(doc.getNodeName())) {
            return;
        }
        NamedNodeMap attr = doc.getAttributes();
        String idText = this.getAttributeText(attr, "id");
        if (idText == null) {
            LOG.error("No id attribute.");
            return;
        }
        try {
            this.collectionId = Integer.parseInt(idText);
        }
        catch (NumberFormatException nfe) {
            LOG.error("Couldn't get collection id from: " + idText, nfe);
            return;
        }
        String timestampText = this.getAttributeText(attr, "timestamp");
        if (timestampText != null) {
            try {
                this.collectionTimestamp = Long.parseLong(timestampText);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Couldn't get timestamp from: " + timestampText, nfe);
            }
        }
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if ("msg".equals(nodeName)) {
                this.parseMsgItem(child, updateDataList);
                continue;
            }
            if ("keyversion".equals(nodeName)) {
                this.keyVersion = LimeXMLUtils.parseInteger(LimeXMLUtils.getTextContent(child), -1);
                continue;
            }
            if ("newversion".equals(nodeName)) {
                this.newVersion = LimeXMLUtils.parseInteger(LimeXMLUtils.getTextContent(child), -1);
                continue;
            }
            if ("signature".equals(nodeName)) {
                this.signature = Base32.decode(LimeXMLUtils.getTextContent(child));
                this.signedPayload = StringUtils.toUTF8Bytes(LimeXMLUtils.stripElement(xml, "signature"));
                continue;
            }
            if (!"certificate".equals(nodeName)) continue;
            try {
                this.certificate = new CertificateParserImpl().parseCertificate(LimeXMLUtils.getTextContent(child));
                continue;
            }
            catch (IOException ie) {
                throw new InvalidDataException(ie);
            }
        }
        if (this.keyVersion <= -1 || this.newVersion <= -1 || this.signature == null) {
            throw new InvalidDataException("missing or invalid data: " + StringUtils.toString(this, this.keyVersion, this.newVersion, this.signature));
        }
    }

    private void parseMsgItem(Node msg, List<UpdateData> updateDataList) {
        UpdateData data = new UpdateData();
        NamedNodeMap attr = msg.getAttributes();
        String fromV = this.getAttributeText(attr, "from");
        String toV = this.getAttributeText(attr, "to");
        String forV = this.getAttributeText(attr, "for");
        String pro = this.getAttributeText(attr, "pro");
        String free = this.getAttributeText(attr, "free");
        String url = this.getAttributeText(attr, "url");
        String style = this.getAttributeText(attr, "style");
        String javaFrom = this.getAttributeText(attr, "javafrom");
        String javaTo = this.getAttributeText(attr, "javato");
        String os = this.getAttributeText(attr, "os");
        String osv = this.getAttributeText(attr, "osv");
        String updateURN = this.getAttributeText(attr, "urn");
        String updateCommand = this.getAttributeText(attr, "ucommand");
        String updateName = this.getAttributeText(attr, "uname");
        String fileSize = this.getAttributeText(attr, "size");
        if (updateURN != null) {
            try {
                URN urn = URN.createSHA1Urn(updateURN);
                String tt = URN.getTigerTreeRoot(updateURN);
                data.setUpdateURN(urn);
                data.setUpdateTTRoot(tt);
            }
            catch (IOException ignored) {
                LOG.warn("Invalid bitprint urn: " + updateURN, ignored);
            }
        }
        data.setUpdateCommand(updateCommand);
        data.setUpdateFileName(updateName);
        if (fileSize != null) {
            try {
                data.setUpdateSize(Integer.parseInt(fileSize));
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Invalid size: " + fileSize);
            }
        }
        if (data.getUpdateURN() != null && data.getUpdateFileName() != null && data.getSize() != 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding new download data item: " + data);
            }
            this.downloadDataList.add(data);
        }
        if (forV == null || url == null || style == null) {
            LOG.error("Missing required for, url, or style.");
            return;
        }
        if (fromV == null) {
            fromV = "0.0.0";
        }
        if (toV == null) {
            toV = forV;
        }
        try {
            data.setFromVersion(new Version(fromV));
            data.setToVersion(new Version(toV));
            data.setForVersion(new Version(forV));
            if (javaFrom != null) {
                data.setFromJava(new Version(javaFrom));
            }
            if (javaTo != null) {
                data.setToJava(new Version(javaTo));
            }
        }
        catch (VersionFormatException vfe) {
            LOG.error("Invalid version", vfe);
            return;
        }
        if (pro == null && free == null) {
            data.setPro(true);
            data.setFree(true);
        } else {
            data.setPro(pro != null);
            data.setFree(free != null);
        }
        url = this.httpClientInstanceUtils.addClientInfoToUrl(url);
        data.setUpdateURL(url);
        try {
            data.setStyle(Integer.parseInt(style));
        }
        catch (NumberFormatException nfe) {
            LOG.error("Invalid style", nfe);
            return;
        }
        if (os == null) {
            os = "*";
        }
        data.setOSList(OS.createFromList(os, osv));
        NodeList children = msg.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!"lang".equals(child.getNodeName())) continue;
            this.parseLangItem((UpdateData)data.clone(), child, updateDataList);
        }
    }

    private void parseLangItem(UpdateData data, Node lang, List<UpdateData> updateDataList) {
        NamedNodeMap attr = lang.getAttributes();
        String id = this.getAttributeText(attr, "id");
        String button1 = this.getAttributeText(attr, "button1");
        String button2 = this.getAttributeText(attr, "button2");
        String title = this.getAttributeText(attr, "title");
        String msg = LimeXMLUtils.getTextContent(lang);
        if (id == null || msg == null || msg.equals("")) {
            LOG.error("Missing id or message.");
            return;
        }
        data.setLanguage(id);
        data.setButton1Text(button1);
        data.setButton2Text(button2);
        data.setUpdateText(msg);
        data.setUpdateTitle(title);
        updateDataList.add(data);
    }

    private String getAttributeText(NamedNodeMap map, String attr) {
        Node node = map.getNamedItem(attr);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    @Override
    public CertifiedMessageVerifier.CertifiedMessage getCertifiedMessage() {
        return new CertifiedMessageVerifier.CertifiedMessage(){

            @Override
            public byte[] getSignedPayload() {
                return UpdateCollectionImpl.this.signedPayload;
            }

            @Override
            public byte[] getSignature() {
                return UpdateCollectionImpl.this.signature;
            }

            @Override
            public int getKeyVersion() {
                return UpdateCollectionImpl.this.keyVersion;
            }

            @Override
            public Certificate getCertificate() {
                return UpdateCollectionImpl.this.certificate;
            }

            public String toString() {
                return StringUtils.toString(UpdateCollectionImpl.this, UpdateCollectionImpl.this.keyVersion, UpdateCollectionImpl.this.signature, UpdateCollectionImpl.this.signedPayload, UpdateCollectionImpl.this.certificate);
            }
        };
    }

    @Override
    public int getNewVersion() {
        return this.newVersion;
    }
}

