/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.bootstrap.Bootstrapper;
import com.limegroup.gnutella.bootstrap.TcpBootstrap;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.EncodingUtils;

class TcpBootstrapImpl
implements TcpBootstrap {
    private static final Log LOG = LogFactory.getLog(TcpBootstrapImpl.class);
    private static final int WANTED_HOSTS = 15;
    private static final int SOCKET_TIMEOUT = 5000;
    private static final int EXPIRY_TIME = 600000;
    private final ExecutorService bootstrapQueue = ExecutorsHelper.newProcessingQueue("TCP Bootstrap");
    private final List<URI> hosts = new ArrayList<URI>();
    private final Set<URI> hostsSet = new HashSet<URI>();
    private final Set<URI> attemptedHosts;
    private boolean dirty = false;
    private final HttpExecutor httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final ConnectionServices connectionServices;

    @Inject
    TcpBootstrapImpl(HttpExecutor httpExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, ConnectionServices connectionServices) {
        this.httpExecutor = httpExecutor;
        this.defaultParams = defaultParams;
        this.connectionServices = connectionServices;
        this.attemptedHosts = new FixedSizeExpiringSet<URI>(100, 600000L);
    }

    @Override
    public synchronized void resetData() {
        LOG.debug("Clearing attempted TCP host caches");
        this.attemptedHosts.clear();
    }

    @Override
    public synchronized boolean fetchHosts(Bootstrapper.Listener listener) {
        if (this.dirty) {
            LOG.debug("Shuffling TCP host caches");
            Collections.shuffle(this.hosts);
            this.dirty = false;
        }
        ArrayList<HttpUriRequest> requests = new ArrayList<HttpUriRequest>();
        HashMap<HttpUriRequest, URI> requestToHost = new HashMap<HttpUriRequest, URI>();
        for (URI host : this.hosts) {
            if (this.attemptedHosts.contains(host)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Already attempted " + host);
                continue;
            }
            HttpUriRequest request = this.newRequest(host);
            requests.add(request);
            requestToHost.put(request, host);
        }
        if (requests.isEmpty()) {
            LOG.debug("No TCP host caches to try");
            return false;
        }
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 5000);
        HttpConnectionParams.setSoTimeout(params, 5000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying 1 of " + requests.size() + " TCP host caches");
        }
        this.httpExecutor.executeAny(new Listener(requestToHost, listener), this.bootstrapQueue, requests, params, new Cancellable(){

            @Override
            public boolean isCancelled() {
                return TcpBootstrapImpl.this.connectionServices.isConnected();
            }
        });
        return true;
    }

    private HttpUriRequest newRequest(URI host) {
        host = URI.create(host.toString() + "?hostfile=1" + "&client=" + "LIME" + "&version=" + EncodingUtils.encode(LimeWireUtils.getLimeWireVersion()));
        HttpGet get = new HttpGet(host);
        get.addHeader("Cache-Control", "no-cache");
        return get;
    }

    private int parseResponse(HttpResponse response, Bootstrapper.Listener listener) {
        if (response.getEntity() == null) {
            LOG.warn("No response entity!");
            return 0;
        }
        String line = null;
        ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
        try {
            InputStream in = response.getEntity().getContent();
            String charset = EntityUtils.getContentCharSet(response.getEntity());
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, charset != null ? charset : "ISO-8859-1"));
            while ((line = reader.readLine()) != null && line.length() > 0) {
                Endpoint host = new Endpoint(line, true);
                endpoints.add(host);
            }
        }
        catch (IllegalArgumentException bad) {
            LOG.error("IAE", bad);
        }
        catch (IOException e) {
            LOG.error("IOX", e);
        }
        if (!endpoints.isEmpty()) {
            return listener.handleHosts(endpoints);
        }
        LOG.debug("no endpoints sent");
        return 0;
    }

    protected synchronized boolean add(URI e) {
        if (this.hostsSet.contains(e)) {
            LOG.debugf("Not adding known TCP host cache {0}", (Object)e);
            return false;
        }
        LOG.debugf("Adding TCP host cache {0}", (Object)e);
        this.hosts.add(e);
        this.hostsSet.add(e);
        this.dirty = true;
        return true;
    }

    @Override
    public void loadDefaults() {
        this.add(URI.create("http://secondary.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://tertiary.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://leet.gtkg.org:8080/gwc/"));
        this.add(URI.create("http://sissy.gtkg.org:8080/gwc/"));
        this.add(URI.create("http://ein.gtkg.net:8080/gwc/"));
        this.add(URI.create("http://zwei.gtkg.net:8080/gwc/"));
        this.add(URI.create("http://drei.gtkg.net:8080/gwc/"));
    }

    private class Listener
    implements HttpClientListener {
        private final Map<HttpUriRequest, URI> hosts;
        private final Bootstrapper.Listener listener;
        private int totalAdded = 0;

        Listener(Map<HttpUriRequest, URI> hosts, Bootstrapper.Listener listener) {
            this.hosts = hosts;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Completed request: " + request.getRequestLine());
            }
            TcpBootstrapImpl tcpBootstrapImpl = TcpBootstrapImpl.this;
            synchronized (tcpBootstrapImpl) {
                TcpBootstrapImpl.this.attemptedHosts.add(this.hosts.remove(request));
            }
            this.totalAdded += TcpBootstrapImpl.this.parseResponse(response, this.listener);
            TcpBootstrapImpl.this.httpExecutor.releaseResources(response);
            return this.totalAdded < 15;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed request: " + request.getRequestLine());
                if (response != null) {
                    LOG.debug("Response " + response);
                }
                if (exc != null) {
                    LOG.debug(exc);
                }
            }
            TcpBootstrapImpl tcpBootstrapImpl = TcpBootstrapImpl.this;
            synchronized (tcpBootstrapImpl) {
                TcpBootstrapImpl.this.attemptedHosts.add(this.hosts.remove(request));
            }
            TcpBootstrapImpl.this.httpExecutor.releaseResources(response);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean allowRequest(HttpUriRequest request) {
            TcpBootstrapImpl tcpBootstrapImpl = TcpBootstrapImpl.this;
            synchronized (tcpBootstrapImpl) {
                return this.hosts.containsKey(request) && !TcpBootstrapImpl.this.attemptedHosts.contains(this.hosts.get(request));
            }
        }
    }
}

