/*
 * Decompiled with CFR 0.152.
 */
package com.openstego.desktop.plugin.randlsb;

import com.openstego.desktop.OpenStegoException;
import com.openstego.desktop.plugin.lsb.LSBConfig;
import com.openstego.desktop.plugin.lsb.LSBDataHeader;
import com.openstego.desktop.plugin.lsb.LSBPlugin;
import com.openstego.desktop.plugin.randlsb.RandomLSBInputStream;
import com.openstego.desktop.plugin.randlsb.RandomLSBOutputStream;
import com.openstego.desktop.util.ImageHolder;
import com.openstego.desktop.util.ImageUtil;
import com.openstego.desktop.util.LabelUtil;
import java.io.IOException;
import java.io.InputStream;

public class RandomLSBPlugin
extends LSBPlugin {
    public static final String NAMESPACE = "RandomLSB";
    private static LabelUtil labelUtil = LabelUtil.getInstance("RandomLSB");

    public RandomLSBPlugin() {
        LabelUtil.addNamespace(NAMESPACE, "i18n.RandomLSBPluginLabels");
    }

    @Override
    public String getName() {
        return NAMESPACE;
    }

    @Override
    public String getDescription() {
        return labelUtil.getString("plugin.description");
    }

    @Override
    public byte[] embedData(byte[] msg, String msgFileName, byte[] cover, String coverFileName, String stegoFileName) throws OpenStegoException {
        int numOfPixels = 0;
        ImageHolder image = null;
        RandomLSBOutputStream lsbOS = null;
        try {
            if (cover == null) {
                numOfPixels = (int)((double)(LSBDataHeader.getMaxHeaderSize() * 8) / 3.0);
                image = ImageUtil.generateRandomImage(numOfPixels += (int)((double)(msg.length * 8) / (3.0 * (double)((LSBConfig)this.config).getMaxBitsUsedPerChannel())));
            } else {
                image = ImageUtil.byteArrayToImage(cover, coverFileName);
            }
            lsbOS = new RandomLSBOutputStream(image, msg.length, msgFileName, this.config);
            lsbOS.write(msg);
            lsbOS.close();
            return ImageUtil.imageToByteArray(lsbOS.getImage(), stegoFileName, this);
        }
        catch (IOException ioEx) {
            throw new OpenStegoException(ioEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String extractMsgFileName(byte[] stegoData, String stegoFileName) throws OpenStegoException {
        InputStream lsbIS = null;
        try {
            lsbIS = new RandomLSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
            String string = ((RandomLSBInputStream)lsbIS).getDataHeader().getFileName();
            return string;
        }
        finally {
            if (lsbIS != null) {
                try {
                    lsbIS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public byte[] extractData(byte[] stegoData, String stegoFileName, byte[] origSigData) throws OpenStegoException {
        int bytesRead = 0;
        byte[] data = null;
        LSBDataHeader header = null;
        InputStream lsbIS = null;
        try {
            lsbIS = new RandomLSBInputStream(ImageUtil.byteArrayToImage(stegoData, stegoFileName), this.config);
            header = ((RandomLSBInputStream)lsbIS).getDataHeader();
            data = new byte[header.getDataLength()];
            bytesRead = lsbIS.read(data, 0, data.length);
            if (bytesRead != data.length) {
                throw new OpenStegoException(null, "LSB", 1);
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (OpenStegoException osEx) {
            throw osEx;
        }
        catch (Exception ex) {
            throw new OpenStegoException(ex);
        }
        finally {
            if (lsbIS != null) {
                try {
                    lsbIS.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String getUsage() throws OpenStegoException {
        LSBConfig defaultConfig = new LSBConfig();
        return labelUtil.getString("plugin.usage", defaultConfig.getMaxBitsUsedPerChannel());
    }
}

