/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mcwin;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.BaseTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class McWinTitlePane
extends BaseTitlePane {
    public McWinTitlePane(JRootPane jRootPane, BaseRootPaneUI baseRootPaneUI) {
        super(jRootPane, baseRootPaneUI);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void createButtons() {
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.restoreAction, "Maximize", this.maximizeIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
    }

    public void paintBorder(Graphics graphics) {
        if (this.isActive()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getWindowBorderColor());
        } else {
            graphics.setColor(AbstractLookAndFeel.getTheme().getWindowInactiveBorderColor());
        }
        graphics.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics graphics, int n, int n2, String string) {
        if (this.isActive()) {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
        } else {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getWindowInactiveTitleColorLight(), 40.0));
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2 + 1);
            graphics.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
            JTattooUtilities.drawString(this.rootPane, graphics, string, n, n2);
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = this.computeHeight();
            return new Dimension(n, n);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        protected int computeHeight() {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(McWinTitlePane.this.getFont());
            return fontMetrics.getHeight() + 6;
        }

        public void layoutContainer(Container container) {
            boolean bl = McWinTitlePane.this.isLeftToRight();
            int n = McWinTitlePane.this.getWidth();
            int n2 = McWinTitlePane.this.getHeight();
            int n3 = 4;
            int n4 = 26;
            if (n2 <= 22) {
                n3 = 2;
                n4 = 18;
            } else if (n2 <= 25) {
                n3 = 3;
                n4 = 22;
            } else {
                n3 = 4;
                n4 = 26;
            }
            int n5 = n4;
            int n6 = bl ? n3 : n - n5 - n3;
            int n7 = Math.max(0, (n2 - n4) / 2 - 1);
            int n8 = 0;
            int n9 = 0;
            int n10 = McWinTitlePane.this.getWidth();
            int n11 = McWinTitlePane.this.getHeight();
            if (McWinTitlePane.this.menuBar != null) {
                int n12 = ((McWinTitlePane)McWinTitlePane.this).menuBar.getPreferredSize().width;
                int n13 = ((McWinTitlePane)McWinTitlePane.this).menuBar.getPreferredSize().height;
                if (bl) {
                    n8 = 4 + n12;
                    McWinTitlePane.this.menuBar.setBounds(2, (n2 - n13) / 2, n12, n13);
                } else {
                    McWinTitlePane.this.menuBar.setBounds(McWinTitlePane.this.getWidth() - n12, (n2 - n13) / 2, n12, n13);
                }
                n10 -= 4 + n12;
            }
            int n14 = n6 = bl ? n - n3 : 0;
            if (McWinTitlePane.this.closeButton != null) {
                McWinTitlePane.this.closeButton.setBounds(n6 += bl ? -n5 : n3, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (McWinTitlePane.this.maxButton != null && McWinTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                McWinTitlePane.this.maxButton.setBounds(n6 += bl ? -n3 - n5 : n3, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            if (McWinTitlePane.this.iconifyButton != null && McWinTitlePane.this.iconifyButton.getParent() != null) {
                McWinTitlePane.this.iconifyButton.setBounds(n6 += bl ? -n3 - n5 : n3, n7, n5, n4);
                if (!bl) {
                    n6 += n5;
                }
            }
            McWinTitlePane.this.buttonsWidth = bl ? n - n6 : n6;
            if (McWinTitlePane.this.customTitlePanel != null) {
                if (!bl) {
                    n8 += McWinTitlePane.this.buttonsWidth;
                }
                n10 -= McWinTitlePane.this.buttonsWidth;
                Graphics graphics = McWinTitlePane.this.getGraphics();
                if (graphics != null) {
                    FontMetrics fontMetrics = graphics.getFontMetrics();
                    int n15 = SwingUtilities.computeStringWidth(fontMetrics, JTattooUtilities.getClippedText(McWinTitlePane.this.getTitle(), fontMetrics, n10));
                    if (bl) {
                        n8 += n15;
                    }
                    n10 -= n15;
                }
                McWinTitlePane.this.customTitlePanel.setBounds(n8, n9, n10, n11);
            }
        }
    }
}

