/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.io.CharArrayReader;

public class CharArray
implements CharSequence {
    private char[] buff;
    private int offset;
    private int length;

    public CharArray(char[] buff) {
        this(buff, 0, buff.length);
    }

    public CharArray(char[] buff, int offset, int length) {
        this.set(buff, offset, length);
    }

    public void set(char[] buff, int offset, int length) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("CharArray index out of range: " + offset);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("CharArray index out of range: " + length);
        }
        if (offset > buff.length - length) {
            throw new StringIndexOutOfBoundsException("CharArray index out of range: " + (offset + length));
        }
        this.buff = buff;
        this.offset = offset;
        this.length = length;
    }

    public char[] buffer() {
        return this.buff;
    }

    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    public char[] toCharArray(boolean clone) {
        if (!clone && this.offset == 0 && this.buff.length == this.length) {
            return this.buff;
        }
        char[] array = new char[this.length];
        System.arraycopy(this.buff, this.offset, array, 0, this.length);
        return array;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(index + " is not in range [0, " + this.length + ")");
        }
        return this.buff[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new IndexOutOfBoundsException("CharArray index out of range: " + start);
        }
        if (end > this.length) {
            throw new IndexOutOfBoundsException("CharArray index out of range: " + end);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("CharArray index out of range: " + (end - start));
        }
        return start == 0 && end == this.length ? this : new CharArray(this.buff, this.offset + start, end - start);
    }

    public CharArrayReader asReader() {
        return new CharArrayReader(this.buffer(), this.offset(), this.length());
    }

    @Override
    public String toString() {
        return new String(this.buff, this.offset, this.length);
    }
}

