/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.xsd.display;

import jlibs.core.graph.visitors.PathReflectionVisitor;
import jlibs.xml.sax.helpers.MyNamespaceSupport;
import jlibs.xml.xsd.XSUtil;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSDisplayValueVisitor
extends PathReflectionVisitor<Object, String> {
    private MyNamespaceSupport nsSupport;

    public XSDisplayValueVisitor(MyNamespaceSupport nsSupport) {
        this.nsSupport = nsSupport;
    }

    protected String getDefault(Object elem) {
        return null;
    }

    protected String process(XSNamespaceItem nsItem) {
        String ns = nsItem.getSchemaNamespace();
        return this.nsSupport.findPrefix(ns != null ? ns : "");
    }

    protected String process(XSElementDeclaration elem) {
        XSComplexTypeDefinition complexType;
        XSTypeDefinition type = elem.getTypeDefinition();
        if (type instanceof XSComplexTypeDefinition && (complexType = (XSComplexTypeDefinition)type).getContentType() == 1) {
            type = complexType.getBaseType();
        }
        if (type instanceof XSComplexTypeDefinition) {
            return null;
        }
        XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)type;
        XSObjectList facets = simpleType.getMultiValueFacets();
        StringBuilder buff = new StringBuilder();
        block9: for (int i = 0; i < facets.getLength(); ++i) {
            XSMultiValueFacet facet = (XSMultiValueFacet)facets.item(i);
            switch (facet.getFacetKind()) {
                case 2048: {
                    StringList list = facet.getLexicalFacetValues();
                    for (int j = 0; j < list.getLength(); ++j) {
                        if (j != 0) {
                            buff.append("|");
                        }
                        buff.append(list.item(j));
                    }
                    continue block9;
                }
            }
        }
        if (buff.length() > 0) {
            return buff.toString();
        }
        String min = null;
        String max = null;
        facets = simpleType.getFacets();
        block11: for (int i = 0; i < facets.getLength(); ++i) {
            XSFacet facet = (XSFacet)facets.item(i);
            switch (facet.getFacetKind()) {
                case 256: {
                    min = '[' + facet.getLexicalFacetValue();
                    continue block11;
                }
                case 128: {
                    min = '(' + facet.getLexicalFacetValue();
                    continue block11;
                }
                case 32: {
                    max = facet.getLexicalFacetValue() + ']';
                    continue block11;
                }
                case 64: {
                    max = facet.getLexicalFacetValue() + ')';
                }
            }
        }
        if (min != null && max != null) {
            return min + ", " + max;
        }
        if (min != null || max != null) {
            if (min != null) {
                String str = min.substring(1);
                return min.charAt(0) == '[' ? ">= " + str : "> " + str;
            }
            String str = max.substring(0, max.length() - 1);
            return max.charAt(max.length() - 1) == '[' ? "<= " + str : "< " + str;
        }
        return XSUtil.getQName((XSObject)type, this.nsSupport);
    }

    protected String process(XSAttributeUse attrUse) {
        return XSUtil.getQName((XSObject)attrUse.getAttrDeclaration().getTypeDefinition(), this.nsSupport);
    }
}

