/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.MenuManager;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.ssl.EasySSLProtocolSocketFactory;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class ClientManager {
    private static final String SOCKS_PREFIX_REGEXP = "^(\\$SOCKS\\$|SOCKS\\:)";
    private static final Logger logger = Logger.getLogger(ClientManager.class.getName());
    private final List<ConnectionSettings> availableConnections = new ArrayList<ConnectionSettings>(2);
    private static final String PROXY_LIST_DEFAULT_PATH = new File(Utils.getAppPath(), "proxy.list").getAbsolutePath();
    private ConnectionSettings defaultConnectionSettings = new ConnectionSettings();
    private final Object connectionSettingsLock = new Object();
    private final ManagerDirector managerDirector;
    private final Map<String, Integer> rotate = new HashMap<String, Integer>();

    public ClientManager(ManagerDirector managerDirector) {
        this.managerDirector = managerDirector;
        this.defaultConnectionSettings.setDefault(true);
        boolean useSystemProxies = AppPrefs.getProperty("useSystemProxies", false);
        if (!useSystemProxies) {
            ProxySelector.setDefault(null);
        }
        this.initSSL();
        this.updateConnectionSettings();
    }

    private void initSSL() {
        try {
            EasySSLProtocolSocketFactory sf = new EasySSLProtocolSocketFactory();
            Protocol p = new Protocol("https", (ProtocolSocketFactory)sf, 443);
            Protocol.registerProtocol("https", p);
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
            logger.warning("SSL initialization failed - some plugins won't work");
        }
    }

    private void updateProxies() {
        String file;
        File f;
        if (AppPrefs.getProperty("useProxyList", false) && (f = new File(file = AppPrefs.getProperty("proxyListPath", PROXY_LIST_DEFAULT_PATH))).exists() && f.isFile() && f.canRead()) {
            try {
                this.readProxyList(f);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
            }
        }
    }

    private void updateDefault() {
        if (this.useDefaultConnection()) {
            boolean isEnabled = this.defaultConnectionSettings.isEnabled();
            this.defaultConnectionSettings = new ConnectionSettings();
            this.defaultConnectionSettings.setDefault(true);
            this.initDefaultProxySettings(this.defaultConnectionSettings);
            this.defaultConnectionSettings.setEnabled(isEnabled);
            this.availableConnections.add(this.defaultConnectionSettings);
        }
        this.setAuthenticator();
    }

    private boolean useDefaultConnection() {
        return AppPrefs.getProperty("useDefaultConnection", true);
    }

    private void initDefaultProxySettings(ConnectionSettings connectionSettings) {
        String proxySetSystemDefault = System.getProperty("proxySet", "false");
        logger.info("Proxy set system default connection: " + proxySetSystemDefault);
        if (AppPrefs.getProperty("proxy", Boolean.valueOf(proxySetSystemDefault))) {
            int port;
            String url = AppPrefs.getProperty("proxy.url", System.getProperty("proxyHost", "localhost"));
            try {
                port = Integer.valueOf(AppPrefs.getProperty("proxy.port", System.getProperty("proxyPort", "8080")));
            }
            catch (NumberFormatException e) {
                port = 8080;
            }
            if (AppPrefs.getProperty("proxy.login", false)) {
                String userName = AppPrefs.getProperty("proxy.username", "");
                String password = Utils.generateXorString(AppPrefs.getProperty("proxy.password", ""));
                connectionSettings.setProxy(url, port, Proxy.Type.HTTP, userName, password);
            } else {
                connectionSettings.setProxy(url, port, Proxy.Type.HTTP);
            }
            boolean socks = AppPrefs.getProperty("defaultConnectionSocks", false);
            if (socks) {
                connectionSettings.setProxyType(Proxy.Type.SOCKS);
            }
            logger.info("Setting proxy configuration ON with configuration: " + connectionSettings.toString());
        } else {
            logger.info("Setting proxy configuration OFF for default connection");
        }
    }

    private void setAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                ConnectionSettings conn;
                if ("SOCKS5".equals(this.getRequestingProtocol()) && (conn = ClientManager.this.findConnectionByParameters(this.getRequestingHost(), this.getRequestingPort(), Proxy.Type.SOCKS)) != null) {
                    String pass = conn.getPassword();
                    char[] password = pass == null ? new char[]{} : pass.toCharArray();
                    return new PasswordAuthentication(conn.getUserName(), password);
                }
                return null;
            }
        });
    }

    private ConnectionSettings findConnectionByParameters(String proxyURL, int proxyPort, Proxy.Type proxyType) {
        List<ConnectionSettings> conns = this.getAvailableConnections();
        for (ConnectionSettings conn : conns) {
            if (conn.getProxyPort() != proxyPort || conn.getProxyType() != proxyType || !conn.getProxyURL().equalsIgnoreCase(proxyURL)) continue;
            return conn;
        }
        return null;
    }

    private void readProxyList(File f) {
        Pattern patternWhole = Pattern.compile("((\\w*)(:(.*?))?@)?(.*?):(\\d{2,5})");
        Pattern socksPattern = Pattern.compile(SOCKS_PREFIX_REGEXP, 2);
        String[] strings = Utils.loadFile(f).split("(\\s)");
        boolean autodetectSOCKS = AppPrefs.getProperty("autodetectSOCKSProxy", true);
        for (String s : strings) {
            Proxy.Type proxyType;
            if (s.isEmpty()) continue;
            Matcher matcherSocks = socksPattern.matcher(s);
            if (matcherSocks.find()) {
                proxyType = Proxy.Type.SOCKS;
                s = s.substring(matcherSocks.group(1).length());
            } else {
                proxyType = Proxy.Type.HTTP;
            }
            Matcher matcher = patternWhole.matcher(s);
            if (matcher.matches()) {
                String s2;
                int i = s.lastIndexOf(64);
                ConnectionSettings settings = new ConnectionSettings();
                if (i >= 0) {
                    String s1 = s.substring(0, i);
                    s2 = s.substring(i + 1);
                    i = s1.indexOf(58);
                    String[] hostPort = s2.split(":");
                    Integer port = Integer.valueOf(hostPort[1]);
                    if (port > 65535) continue;
                    if (autodetectSOCKS && port >= 1080 && port <= 1090) {
                        proxyType = Proxy.Type.SOCKS;
                    }
                    if (i > 0) {
                        settings.setProxy(hostPort[0], port, proxyType, s1.substring(0, i), s1.substring(i + 1));
                    } else {
                        settings.setProxy(hostPort[0], port, proxyType, s1, null);
                    }
                } else {
                    s2 = s;
                    String[] hostPort = s2.split(":");
                    Integer port = Integer.valueOf(hostPort[1]);
                    if (port > 65535) continue;
                    if (autodetectSOCKS && port >= 1080 && port <= 1090) {
                        proxyType = Proxy.Type.SOCKS;
                    }
                    settings.setProxy(hostPort[0], port, proxyType);
                }
                this.availableConnections.add(settings);
                logger.info("Reading proxy definition " + settings.toString());
                continue;
            }
            logger.warning("String " + s + " does not match to proxy definition pattern - [username[:password@]]host:port");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getAvailableConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.availableConnections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getEnabledConnections() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.getEnabled());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConnectionSettings> getRotatedEnabledConnections(String id) {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            ArrayList<ConnectionSettings> list = new ArrayList<ConnectionSettings>(this.availableConnections.size());
            for (ConnectionSettings settings : this.availableConnections) {
                if (!settings.isEnabled() || settings.isDefault()) continue;
                list.add(settings);
            }
            if (list.size() > 1) {
                Collections.rotate(list, this.getNextRotation(id));
            }
            if (this.useDefaultConnection() && this.defaultConnectionSettings.isEnabled()) {
                list.add(0, this.defaultConnectionSettings);
            }
            return list;
        }
    }

    private int getNextRotation(String id) {
        if (this.rotate.containsKey(id)) {
            int r = this.rotate.get(id);
            this.rotate.put(id, ++r);
            logger.info("Rotate for '" + id + "' is: " + r);
            return r;
        }
        this.rotate.put(id, 0);
        return 0;
    }

    private List<ConnectionSettings> getEnabled() {
        LinkedList<ConnectionSettings> list = new LinkedList<ConnectionSettings>();
        for (ConnectionSettings settings : this.availableConnections) {
            if (!settings.isEnabled()) continue;
            list.add(settings);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionEnabled(ConnectionSettings settings, boolean enabled) {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            settings.setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionSettings() {
        Object object = this.connectionSettingsLock;
        synchronized (object) {
            this.availableConnections.clear();
            this.updateDefault();
            this.updateProxies();
        }
        MenuManager menuManager = this.managerDirector.getMenuManager();
        if (menuManager != null) {
            menuManager.updateConnectionSettings(this.getAvailableConnections());
        }
    }
}

