/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;

final class OneInstanceServer
extends Thread {
    private static final Logger logger = Logger.getLogger(OneInstanceServer.class.getName());
    private final AppPrefs prefs;
    private volatile ServerSocket serverSocket;

    public OneInstanceServer(AppPrefs prefs) {
        this.prefs = prefs;
        this.setPriority(1);
    }

    @Override
    public final void run() {
        block14: {
            this.setName("OneInstanceServer");
            Socket clientSocket = null;
            try {
                logger.info("Creating a local socket server");
                String portString = AppPrefs.getProperty("oneInstanceServerPort", null);
                this.serverSocket = null;
                if (portString == null) {
                    int checkPort = 39871;
                    int attempts = 10;
                    while (--attempts > 0) {
                        try {
                            logger.info("Trying to create a local socket server on port " + checkPort);
                            this.serverSocket = new ServerSocket(checkPort, 1);
                            AppPrefs.storeProperty("oneInstanceServerPort", checkPort);
                            this.prefs.store();
                            break;
                        }
                        catch (IOException e) {
                            logger.info("Failed to create a local socket server on port " + checkPort + "  Reason:" + e.getMessage());
                            ++checkPort;
                        }
                    }
                } else {
                    this.serverSocket = new ServerSocket(AppPrefs.getProperty("oneInstanceServerPort", 39871), 1);
                }
                if (this.serverSocket == null) {
                    throw new IOException("Cannot find available free port for starting");
                }
                while (!this.isInterrupted()) {
                    String line;
                    logger.info("Waiting for connection");
                    clientSocket = this.serverSocket.accept();
                    logger.info("Got a connection");
                    BufferedReader stream = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                    while ((line = stream.readLine()) != null) {
                        if (line.length() == 0 || line.startsWith("-") || !"\n".equals(line)) continue;
                    }
                    stream.close();
                    clientSocket.close();
                    MainApp app = MainApp.getInstance(MainApp.class);
                    app.getMainFrame().toFront();
                }
            }
            catch (IOException e) {
                if (clientSocket != null) {
                    try {
                        clientSocket.close();
                    }
                    catch (IOException e1) {
                        LogUtils.processException(logger, e);
                    }
                }
                if (this.serverSocket.isClosed()) break block14;
                LogUtils.processException(logger, e);
            }
        }
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }
}

