/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamePreservingRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamePreservingRunnable.class);
    private final String newName;
    private final Runnable runnable;

    public NamePreservingRunnable(Runnable runnable, String string) {
        this.runnable = runnable;
        this.newName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        if (this.newName != null) {
            this.setName(thread, this.newName);
        }
        try {
            this.runnable.run();
        }
        finally {
            this.setName(thread, string);
        }
    }

    private void setName(Thread thread, String string) {
        block2: {
            try {
                thread.setName(string);
            }
            catch (SecurityException securityException) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Failed to set the thread name.", (Throwable)securityException);
            }
        }
    }
}

