/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.icon.TransitionAware;
import org.jvnet.substance.utils.icon.TransitionAwareIcon;

@TransitionAware
public class ArrowButtonTransitionAwareIcon
implements Icon {
    private static LazyResettableHashMap<Icon> iconMap = new LazyResettableHashMap("ButtonArrowTransitionAwareIcon");
    private int orientation;
    protected int iconWidth;
    protected int iconHeight;
    protected TransitionAwareIcon.Delegate delegate;

    public ArrowButtonTransitionAwareIcon(final AbstractButton button, final int orientation) {
        this.orientation = orientation;
        this.delegate = new TransitionAwareIcon.Delegate(){

            @Override
            public Icon getColorSchemeIcon(SubstanceColorScheme scheme) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
                return SubstanceImageCreator.getArrowIcon(fontSize, orientation, scheme);
            }
        };
        this.iconWidth = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(button, ComponentState.DEFAULT)).getIconWidth();
        this.iconHeight = this.delegate.getColorSchemeIcon(SubstanceColorSchemeUtilities.getColorScheme(button, ComponentState.DEFAULT)).getIconHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint((AbstractButton)c).paintIcon(c, g, x, y);
    }

    private Icon getIconToPaint(AbstractButton button) {
        SubstanceColorScheme currScheme;
        ButtonModel model = button.getModel();
        ComponentState currState = ComponentState.getState(model, button, button instanceof JMenu);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(button);
        if (!currState.isKindActive(FadeKind.ENABLE)) {
            prevState = currState;
        }
        float cyclePos = currState.getCyclePosition();
        SubstanceColorScheme prevScheme = currScheme = SubstanceColorSchemeUtilities.getColorScheme(button, button instanceof JMenu && currState.isKindActive(FadeKind.ROLLOVER) ? ColorSchemeAssociationKind.HIGHLIGHT : ColorSchemeAssociationKind.MARK, currState);
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)button, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS, FadeKind.ARM);
        if (fadeState != null) {
            prevScheme = SubstanceColorSchemeUtilities.getColorScheme(button, button instanceof JMenu && prevState.isKindActive(FadeKind.ROLLOVER) ? ColorSchemeAssociationKind.HIGHLIGHT : ColorSchemeAssociationKind.MARK, prevState);
            cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
        }
        float currAlpha = SubstanceColorSchemeUtilities.getAlpha(button, currState);
        float prevAlpha = SubstanceColorSchemeUtilities.getAlpha(button, prevState);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(button.getClass().getName(), this.orientation, SubstanceSizeUtils.getComponentFontSize(button), currScheme.getDisplayName(), prevScheme.getDisplayName(), Float.valueOf(currAlpha), Float.valueOf(prevAlpha), Float.valueOf(cyclePos));
        if (!iconMap.containsKey(key)) {
            Icon icon = this.delegate.getColorSchemeIcon(currScheme);
            Icon prevIcon = this.delegate.getColorSchemeIcon(prevScheme);
            BufferedImage temp = SubstanceCoreUtilities.getBlankImage(icon.getIconWidth(), icon.getIconHeight());
            Graphics2D g2d = temp.createGraphics();
            if (currScheme == prevScheme) {
                g2d.setComposite(AlphaComposite.getInstance(3, currAlpha));
                icon.paintIcon(button, g2d, 0, 0);
            } else {
                if (cyclePos < 1.0f) {
                    g2d.setComposite(AlphaComposite.SrcOver.derive(prevAlpha));
                    prevIcon.paintIcon(button, g2d, 0, 0);
                }
                if (cyclePos > 0.0f) {
                    g2d.setComposite(AlphaComposite.SrcOver.derive(currAlpha * cyclePos));
                    icon.paintIcon(button, g2d, 0, 0);
                }
            }
            iconMap.put(key, new ImageIcon(temp));
            g2d.dispose();
        }
        return iconMap.get(key);
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }
}

