/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import org.jvnet.substance.api.ColorSchemeTransform;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.painter.border.StandardBorderPainter;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class DelegateBorderPainter
extends StandardBorderPainter {
    protected String displayName;
    protected StandardBorderPainter delegate;
    protected int topMask;
    protected int midMask;
    protected int bottomMask;
    protected ColorSchemeTransform transform;
    protected static LazyResettableHashMap<SubstanceColorScheme> transformMap = new LazyResettableHashMap("DelegateBorderPainter");

    public DelegateBorderPainter(String displayName, StandardBorderPainter delegate, ColorSchemeTransform transform) {
        this(displayName, delegate, -1, -1, -1, transform);
    }

    public DelegateBorderPainter(String displayName, StandardBorderPainter delegate, int topMask, int midMask, int bottomMask, ColorSchemeTransform transform) {
        this.displayName = displayName;
        this.delegate = delegate;
        this.topMask = topMask;
        this.midMask = midMask;
        this.bottomMask = bottomMask;
        this.transform = transform;
    }

    @Override
    public Color getTopBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return new Color(this.topMask & this.delegate.getTopBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation).getRGB(), true);
    }

    @Override
    public Color getMidBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return new Color(this.midMask & this.delegate.getMidBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation).getRGB(), true);
    }

    @Override
    public Color getBottomBorderColor(SubstanceColorScheme interpolationScheme1, SubstanceColorScheme interpolationScheme2, double cycleCoef, boolean useCyclePosAsInterpolation) {
        return new Color(this.bottomMask & this.delegate.getBottomBorderColor(interpolationScheme1, interpolationScheme2, cycleCoef, useCyclePosAsInterpolation).getRGB(), true);
    }

    @Override
    public void paintBorder(Graphics g, Component c, int width, int height, Shape contour, Shape innerContour, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos, boolean useCyclePosAsInterpolation) {
        super.paintBorder(g, c, width, height, contour, innerContour, this.getShiftScheme(colorScheme1), this.getShiftScheme(colorScheme2), cyclePos, useCyclePosAsInterpolation);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    private SubstanceColorScheme getShiftScheme(SubstanceColorScheme orig) {
        HashMapKey key = SubstanceCoreUtilities.getHashKey(orig.getDisplayName(), this.getDisplayName(), this.transform);
        if (!transformMap.containsKey(key)) {
            transformMap.put(key, this.transform.transform(orig));
        }
        return transformMap.get(key);
    }
}

