/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.animation;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.FadeConfigurationManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerAdapter;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class FadeStateListener {
    protected FadeTrackerCallback callback;
    protected Component comp;
    protected ButtonModel buttonModel;
    protected Comparable<?> extraKey;
    protected Map<FadeKind, Boolean> prevStateMap;
    protected ChangeListener modelListener;
    protected FocusListener focusListener;
    protected long focusLoopFadeInstanceId;
    protected Set<FadeKind> toIgnore;

    public FadeStateListener(Component comp, ButtonModel buttonModel, FadeTrackerCallback callback) {
        this(comp, null, buttonModel, callback, null);
    }

    public FadeStateListener(Component comp, Comparable<?> extraKey, ButtonModel buttonModel, FadeTrackerCallback callback, Set<FadeKind> toIgnore) {
        this.comp = comp;
        this.extraKey = extraKey;
        this.buttonModel = buttonModel;
        this.callback = callback;
        this.prevStateMap = new HashMap<FadeKind, Boolean>();
        if (buttonModel != null) {
            this.prevStateMap.put(FadeKind.SELECTION, buttonModel.isSelected());
            this.prevStateMap.put(FadeKind.ARM, buttonModel.isArmed());
            this.prevStateMap.put(FadeKind.ROLLOVER, buttonModel.isRollover());
            this.prevStateMap.put(FadeKind.PRESS, buttonModel.isPressed());
            this.prevStateMap.put(FadeKind.ENABLE, buttonModel.isEnabled());
        }
        this.prevStateMap.put(FadeKind.FOCUS, comp.hasFocus());
        this.focusLoopFadeInstanceId = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackModelChange(FadeKind fadeKind, boolean newValue, boolean toRepaintParent) {
        if (LafWidgetUtilities.toIgnoreAnimations(this.comp)) {
            return;
        }
        if (this.toIgnore != null && this.toIgnore.contains(fadeKind)) {
            if (this.callback != null) {
                this.callback.fadeEnded(fadeKind);
            } else {
                this.comp.repaint();
            }
            return;
        }
        try {
            if (this.prevStateMap.containsKey(fadeKind)) {
                boolean prevValue = this.prevStateMap.get(fadeKind);
                if (prevValue == newValue) {
                    return;
                }
            } else {
                if (!newValue) {
                    return;
                }
                if (fadeKind == FadeKind.SELECTION) {
                    if (this.callback != null) {
                        this.callback.fadeEnded(FadeKind.SELECTION);
                    }
                    return;
                }
            }
            if (newValue) {
                FadeTracker.getInstance().trackFadeIn(fadeKind, this.comp, this.extraKey, toRepaintParent, this.callback);
            } else {
                FadeTracker.getInstance().trackFadeOut(fadeKind, this.comp, this.extraKey, toRepaintParent, this.callback);
            }
        }
        finally {
            this.prevStateMap.put(fadeKind, newValue);
        }
    }

    public void registerListeners() {
        this.registerListeners(false);
    }

    public void registerListeners(final boolean toRepaintParent) {
        this.modelListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (FadeStateListener.this.buttonModel == null) {
                    return;
                }
                LafWidgetUtilities.testComponentStateChangeThreadingViolation(FadeStateListener.this.comp);
                FadeStateListener.this.trackModelChange(FadeKind.SELECTION, FadeStateListener.this.buttonModel.isSelected(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeKind.ARM, FadeStateListener.this.buttonModel.isArmed(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeKind.ROLLOVER, FadeStateListener.this.buttonModel.isRollover(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeKind.ENABLE, FadeStateListener.this.buttonModel.isEnabled(), toRepaintParent);
                FadeStateListener.this.trackModelChange(FadeKind.PRESS, FadeStateListener.this.buttonModel.isPressed(), toRepaintParent);
            }
        };
        if (this.buttonModel != null) {
            this.buttonModel.addChangeListener(this.modelListener);
        }
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeKind.FOCUS, true, toRepaintParent);
                FadeStateListener.this.initiateFocusFadeLoop();
            }

            @Override
            public void focusLost(FocusEvent e) {
                FadeStateListener.this.trackModelChange(FadeKind.FOCUS, false, toRepaintParent);
                if (FadeStateListener.this.focusLoopFadeInstanceId >= 0L) {
                    FadeTracker.getInstance().cancelFadeInstance(FadeStateListener.this.focusLoopFadeInstanceId);
                }
            }
        };
        this.comp.addFocusListener(this.focusListener);
        if (this.comp.hasFocus()) {
            this.initiateFocusFadeLoop();
        }
    }

    protected void initiateFocusFadeLoop() {
        FadeTrackerCallback loopCallback;
        FadeTrackerCallback fadeTrackerCallback = loopCallback = this.callback != null ? this.callback : new FadeTrackerAdapter(){

            @Override
            public void fadeEnded(FadeKind fadeKind) {
                FadeStateListener.this.comp.repaint();
            }

            @Override
            public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
                FadeStateListener.this.comp.repaint();
            }
        };
        if (FadeConfigurationManager.getInstance().fadeAllowed(FadeKind.FOCUS_LOOP_ANIMATION, this.comp)) {
            this.focusLoopFadeInstanceId = FadeTracker.getInstance().trackFadeLooping(FadeKind.FOCUS_LOOP_ANIMATION, LafWidgetUtilities.getAnimationKind(this.comp), this.comp, this.extraKey, false, loopCallback, -1, false);
        }
    }

    public void unregisterListeners() {
        if (this.buttonModel != null) {
            this.buttonModel.removeChangeListener(this.modelListener);
        }
        this.comp.removeFocusListener(this.focusListener);
    }
}

