/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nimrod;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import net.sf.nimrod.NimRODLookAndFeel;
import net.sf.nimrod.NimRODUtils;

public class NimRODTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color selectColor;
    private int inclTab = 12;
    private int anchoFocoH = 0;
    private int anchoCarpetas = 18;
    private int rollover = -1;
    private int antRollover = -1;
    private MiML miml;
    private Polygon shape;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.rollover = -1;
        this.selectColor = NimRODLookAndFeel.getFocusColor();
        this.tabAreaInsets.right = this.anchoCarpetas;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.miml = new MiML();
        this.tabPane.addMouseMotionListener(this.miml);
        this.tabPane.addMouseListener(this.miml);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseMotionListener(this.miml);
        this.tabPane.removeMouseListener(this.miml);
    }

    @Override
    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Rectangle tabRectPeq = new Rectangle(tabRect);
        tabRectPeq.width -= this.inclTab;
        super.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRectPeq, iconRect, textRect, isSelected);
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        if (this.runCount > 1) {
            int[] lines = new int[this.runCount];
            for (int i = 0; i < this.runCount; ++i) {
                lines[i] = this.rects[this.tabRuns[i]].y + (tabPlacement == 1 ? this.maxTabHeight : 0);
            }
            Arrays.sort(lines);
            Graphics2D g2D = (Graphics2D)g;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (tabPlacement == 1) {
                int fila = this.runCount;
                int i = 0;
                while (i < lines.length - 1) {
                    Polygon carp = new Polygon();
                    carp.addPoint(0, lines[i]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 2, lines[i]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila, lines[i] + 3);
                    if (i < lines.length - 2) {
                        carp.addPoint(this.tabPane.getWidth() - 2 * fila, lines[i + 1]);
                        carp.addPoint(0, lines[i + 1]);
                    } else {
                        carp.addPoint(this.tabPane.getWidth() - 2 * fila, lines[i] + this.rects[selectedIndex].height);
                        carp.addPoint(0, lines[i] + this.rects[selectedIndex].height);
                    }
                    carp.addPoint(0, lines[i]);
                    g2D.setColor(this.hazAlfa(fila));
                    g2D.fillPolygon(carp);
                    g2D.setColor(this.darkShadow.darker());
                    g2D.drawPolygon(carp);
                    ++i;
                    --fila;
                }
            } else {
                int fila = 0;
                int i = 0;
                while (i < lines.length - 1) {
                    Polygon carp = new Polygon();
                    carp.addPoint(0, lines[i]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 1, lines[i]);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 1, lines[i + 1] - 3);
                    carp.addPoint(this.tabPane.getWidth() - 2 * fila - 3, lines[i + 1]);
                    carp.addPoint(0, lines[i + 1]);
                    carp.addPoint(0, lines[i]);
                    g2D.setColor(this.hazAlfa(fila + 2));
                    g2D.fillPolygon(carp);
                    g2D.setColor(this.darkShadow.darker());
                    g2D.drawPolygon(carp);
                    ++i;
                    ++fila;
                }
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        GradientPaint gradientShadow;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] xp = null;
        int[] yp = null;
        switch (tabPlacement) {
            case 2: {
                xp = new int[]{x, x, x + w, x + w, x};
                yp = new int[]{y, y + h - 3, y + h - 3, y, y};
                gradientShadow = new GradientPaint(x, y, NimRODUtils.getBrillo(), x, y + h, NimRODUtils.getSombra());
                break;
            }
            case 4: {
                xp = new int[]{x, x, x + w - 2, x + w - 2, x};
                yp = new int[]{y, y + h - 3, y + h - 3, y, y};
                gradientShadow = new GradientPaint(x, y, NimRODUtils.getBrillo(), x, y + h, NimRODUtils.getSombra());
                break;
            }
            case 3: {
                xp = new int[]{x, x, x + 3, x + w - this.inclTab - 6, x + w - this.inclTab - 2, x + w - this.inclTab, x + w - 3, x};
                yp = new int[]{y, y + h - 3, y + h, y + h, y + h - 1, y + h - 3, y, y};
                gradientShadow = new GradientPaint(x, y, NimRODUtils.getBrillo(), x, y + h, NimRODUtils.getSombra());
                break;
            }
            default: {
                xp = new int[]{x, x, x + 3, x + w - this.inclTab - 6, x + w - this.inclTab - 2, x + w - this.inclTab, x + w, x};
                yp = new int[]{y + h, y + 3, y, y, y + 1, y + 3, y + h, y + h};
                gradientShadow = new GradientPaint(x, y, NimRODUtils.getBrillo(), x, y + h, NimRODUtils.getSombra());
            }
        }
        this.shape = new Polygon(xp, yp, xp.length);
        if (isSelected) {
            g2D.setColor(this.selectColor);
        } else {
            g2D.setColor(this.tabPane.getBackgroundAt(tabIndex));
        }
        g2D.fill(this.shape);
        if (this.runCount > 1) {
            g2D.setColor(this.hazAlfa(this.getRunForTab(this.tabPane.getTabCount(), tabIndex) - 1));
            g2D.fill(this.shape);
        }
        if (tabIndex == this.rollover) {
            g2D.setColor(NimRODUtils.getRolloverColor());
            g2D.fill(this.shape);
        }
        g2D.setPaint(gradientShadow);
        g2D.fill(this.shape);
        g2D.setColor(NimRODUtils.getSombra());
        g2D.draw(this.shape);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    @Override
    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        return 8 + this.inclTab + super.calculateTabWidth(tabPlacement, tabIndex, metrics);
    }

    @Override
    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        if (tabPlacement == 2 || tabPlacement == 4) {
            return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        }
        return this.anchoFocoH + super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.hasFocus() && isSelected) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            g2d.setColor(UIManager.getColor("ScrollBar.thumbShadow"));
            g2d.drawPolygon(this.shape);
            g2d.setStroke(oldStroke);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    protected Color hazAlfa(int fila) {
        int alfa = 0;
        if (fila >= 0) {
            alfa = 50 + (fila > 7 ? 70 : 8 * fila);
        }
        return new Color(0, 0, 0, alfa);
    }

    public class MiML
    extends MouseAdapter
    implements MouseMotionListener {
        @Override
        public void mouseExited(MouseEvent e) {
            NimRODTabbedPaneUI.this.rollover = -1;
            NimRODTabbedPaneUI.this.tabPane.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            NimRODTabbedPaneUI.this.rollover = NimRODTabbedPaneUI.this.tabForCoordinate(NimRODTabbedPaneUI.this.tabPane, e.getX(), e.getY());
            if (NimRODTabbedPaneUI.this.rollover == -1 && NimRODTabbedPaneUI.this.antRollover == NimRODTabbedPaneUI.this.rollover) {
                return;
            }
            NimRODTabbedPaneUI.this.tabPane.repaint();
            NimRODTabbedPaneUI.this.antRollover = NimRODTabbedPaneUI.this.rollover;
        }
    }
}

