/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Color;
import java.awt.Component;
import java.awt.color.ColorSpace;
import net.sourceforge.napkinlaf.NapkinTheme;
import net.sourceforge.napkinlaf.NapkinThemeColor;
import net.sourceforge.napkinlaf.util.NapkinUtil;

public class TemplateColor {
    private static final float[] DUMMY_FLOATS = new float[3];
    public static final Color BACKGROUND = TemplateColor.specialColor(NapkinThemeColor.BACKGROUND_COLOR);
    public static final Color CHECK = TemplateColor.specialColor(NapkinThemeColor.CHECK_COLOR);
    public static final Color HIGHLIGHT = TemplateColor.specialColor(NapkinThemeColor.HIGHLIGHT_COLOR);
    public static final Color PEN = TemplateColor.specialColor(NapkinThemeColor.PEN_COLOR);
    public static final Color RADIO = TemplateColor.specialColor(NapkinThemeColor.RADIO_COLOR);
    public static final Color ROLLOVER = TemplateColor.specialColor(NapkinThemeColor.ROLLOVER_COLOR);
    public static final Color SELECTION = TemplateColor.specialColor(NapkinThemeColor.SELECTION_COLOR);

    private static Color specialColor(NapkinThemeColor themeColor) {
        return new Color(new SpecialSpace(themeColor), DUMMY_FLOATS, 1.0f);
    }

    public static Color colorFor(Color color, Component c, NapkinThemeColor themeColor) {
        if (color == null) {
            return NapkinUtil.currentTheme(c).getColor(themeColor);
        }
        if (!TemplateColor.isSpecial(color)) {
            return color;
        }
        SpecialSpace space = (SpecialSpace)color.getColorSpace();
        NapkinTheme theme = NapkinUtil.currentTheme(c);
        return theme.getColor(space.themeColor);
    }

    public static boolean isSpecial(Color color) {
        return color.getColorSpace() instanceof SpecialSpace;
    }

    public static String nameFor(Color color) {
        if (!TemplateColor.isSpecial(color)) {
            return null;
        }
        SpecialSpace space = (SpecialSpace)color.getColorSpace();
        return space.themeColor.toString();
    }

    public static Color colorFor(NapkinThemeColor color) {
        NapkinTheme theme = NapkinTheme.Manager.getCurrentTheme();
        return theme.colorFor(color);
    }

    private static class SpecialSpace
    extends ColorSpace {
        private final NapkinThemeColor themeColor;

        public SpecialSpace(NapkinThemeColor themeColor) {
            super(0, 0);
            this.themeColor = themeColor;
        }

        public float[] fromCIEXYZ(float[] colorvalue) {
            return DUMMY_FLOATS;
        }

        public float[] fromRGB(float[] rgbvalue) {
            return DUMMY_FLOATS;
        }

        public float[] toCIEXYZ(float[] colorvalue) {
            return DUMMY_FLOATS;
        }

        public float[] toRGB(float[] colorvalue) {
            return DUMMY_FLOATS;
        }
    }
}

