/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.Borders;
import com.digitprop.tonic.ButtonUI;
import com.digitprop.tonic.ToolBarBorder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.text.View;

public class ToolButtonUI
extends ButtonUI {
    private static final BorderUIResource defaultBorder = new BorderUIResource(Borders.getButtonBorder());
    private static Hashtable opaqueTable = new Hashtable();
    private Color highlightColor = UIManager.getColor("Button.highlight");
    private Color focusColor = UIManager.getColor("Button.focusBorderColor");
    private Color activeBg = UIManager.getColor("ToolButton.activeBackground");
    private Color activeFg = UIManager.getColor("ToolButton.activeForeground");
    private Color activeBorder = UIManager.getColor("ToolButton.activeBorderColor");

    public static ComponentUI createUI(JComponent c) {
        if (c instanceof JButton) {
            return new ToolButtonUI();
        }
        return MetalButtonUI.createUI(c);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicButtonListener(b);
    }

    protected int getTextShiftOffset() {
        return 1;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    public void paint(Graphics g, JComponent c) {
        if (c instanceof AbstractButton) {
            Border border;
            AbstractButton button = (AbstractButton)c;
            Insets insets = c.getInsets();
            if (button.getModel().isRollover()) {
                g.setColor(new Color(230, 230, 255));
            } else {
                g.setColor(c.getBackground());
            }
            g.fillRect(insets.left, insets.top, c.getWidth() - insets.left - insets.right, c.getHeight() - insets.top - insets.bottom);
            if (button.getModel().isPressed() || button.isEnabled() && button.isSelected()) {
                this.paintButtonPressed(g, button);
            } else if (button.getModel().isRollover() && (border = button.getBorder()) == null) {
                g.setColor(this.activeBorder);
                g.drawRect(insets.left, insets.top, c.getWidth() - insets.left - insets.right - 1, c.getHeight() - insets.top - insets.bottom - 1);
            }
        }
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = b.getWidth() - (i.right + viewRect.x);
        viewRect.height = b.getHeight() - (i.bottom + viewRect.y);
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return super.getPreferredSize(c);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        Border border = b.getBorder();
        if (border == null || !(border instanceof ToolBarBorder)) {
            Insets insets = b.getInsets();
            g.setColor(this.activeBorder);
            g.drawRect(insets.left, insets.top, b.getWidth() - insets.left - insets.right - 1, b.getHeight() - insets.top - insets.bottom - 1);
        }
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Border border;
        if (!(b.getModel().isPressed() || (border = b.getBorder()) != null && border instanceof ToolBarBorder)) {
            Insets insets = b.getInsets();
            int left = insets.left + 2;
            int top = insets.top + 2;
            int right = b.getWidth() - insets.left - insets.right - 2;
            int bottom = b.getHeight() - insets.top - insets.bottom - 2;
            g.setColor(this.focusColor);
            BasicGraphicsUtils.drawDashedRect(g, left, top, right - left + 1, bottom - top + 1);
        }
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        if (c instanceof AbstractButton) {
            this.paintText(g, (AbstractButton)c, textRect, text);
        }
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isPressed()) {
            textRect.x += this.getTextShiftOffset();
            textRect.y += this.getTextShiftOffset();
        }
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        } else {
            g.setColor(Color.WHITE);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x + 1, textRect.y + fm.getAscent() + 1);
            g.setColor(this.getDisabledTextColor());
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }
}

