/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.RootPaneUI;
import com.digitprop.tonic.TonicLookAndFeel;
import com.digitprop.tonic.TonicUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

class TitlePane
extends JComponent {
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private RootPaneUI rootPaneUI;
    private Color inactiveBackground = UIManager.getColor("inactiveCaption");
    private Color inactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color inactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color activeBumpsHighlight = TonicLookAndFeel.getPrimaryControlHighlight();
    private Color activeBumpsShadow = TonicLookAndFeel.getPrimaryControlDarkShadow();
    private Color activeBackground = null;
    private Color activeForeground = null;
    private Color activeShadow = null;

    public TitlePane(JRootPane root, RootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        if (this.getWindowDecorationStyle() == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.activeShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.activeBackground = UIManager.getColor("activeCaption");
                this.activeForeground = UIManager.getColor("activeCaptionText");
                this.activeShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setOpaque(false);
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        Locale locale = this.getRootPane().getLocale();
        JMenuItem mi = menu.add(this.restoreAction);
        int mnemonic = TonicUtils.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        mi = menu.add(this.iconifyAction);
        mnemonic = TonicUtils.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mnemonic = TonicUtils.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
        }
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mnemonic = TonicUtils.getInt("MetalTitlePane.closeMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
    }

    private JButton createTitleButton() {
        JButton button = new JButton();
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(false);
        return button;
    }

    private void createButtons() {
        this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.closeButton = this.createTitleButton();
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.closeButton.putClientProperty("paintActive", Boolean.TRUE);
        this.closeButton.setBorder(handyEmptyBorder);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.closeButton.setIcon(UIManager.getIcon("InternalFrame.closeIcon"));
        this.closeButton.setBackground(Color.WHITE);
        this.iconifyButton = this.createTitleButton();
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setText(null);
        this.iconifyButton.putClientProperty("paintActive", Boolean.TRUE);
        this.iconifyButton.setBorder(handyEmptyBorder);
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.iconifyButton.setIcon(UIManager.getIcon("InternalFrame.iconifyIcon"));
        this.iconifyButton.setBackground(Color.WHITE);
        this.toggleButton = this.createTitleButton();
        this.toggleButton.setAction(this.restoreAction);
        this.toggleButton.putClientProperty("paintActive", Boolean.TRUE);
        this.toggleButton.setBorder(handyEmptyBorder);
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
        this.toggleButton.setIcon(this.maximizeIcon);
        this.toggleButton.setBackground(Color.WHITE);
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.closeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return "";
    }

    public void paintComponent(Graphics g) {
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        Color gradStartColor = null;
        Color gradEndColor = null;
        Color fontColor = null;
        if (this.window.isActive()) {
            gradStartColor = UIManager.getColor("InternalFrame.activeTitleBackground");
            gradEndColor = UIManager.getColor("InternalFrame.activeTitleGradientColor");
            fontColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        } else {
            gradStartColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            gradEndColor = UIManager.getColor("InternalFrame.inactiveTitleGradientColor");
            fontColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        }
        g.setColor(gradEndColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawGradient(g, 0, Math.max(60, this.getWidth() - 60), 0, this.getHeight(), gradStartColor, gradEndColor);
        if (this.getTitle() != null) {
            g.setFont(UIManager.getFont("InternalFrame.font"));
            g.setColor(fontColor);
            FontMetrics fm = g.getFontMetrics();
            int yOffset = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
            int xOffset = 24;
            g.drawString(this.getTitle(), xOffset, yOffset);
        }
        g.setColor(UIManager.getColor("Button.borderColor"));
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private void drawGradient(Graphics g, int x1, int x2, int y, int height, Color c1, Color c2) {
        int step = 1;
        if (x2 - x1 + 1 > 256) {
            step = (x2 - x1 + 1) / 256;
        }
        int i = x1;
        while (i < x2) {
            Color c = this.blendColors(c1, c2, (double)(i - x1) / (double)(x2 - x1));
            g.setColor(c);
            g.fillRect(i, y, step, height);
            i += step;
        }
    }

    private Color blendColors(Color c1, Color c2, double fraction) {
        if (fraction < 0.0) {
            fraction = 0.0;
        } else if (fraction > 1.0) {
            fraction = 1.0;
        }
        int r = (int)((double)c1.getRed() * (1.0 - fraction) + (double)c2.getRed() * fraction);
        int g = (int)((double)c1.getGreen() * (1.0 - fraction) + (double)c2.getGreen() * fraction);
        int b = (int)((double)c1.getBlue() * (1.0 - fraction) + (double)c2.getBlue() * fraction);
        return new Color(r, g, b);
    }

    private String clippedText(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            int nChars = 0;
            while (nChars < text.length()) {
                if ((totalWidth += fm.charWidth(text.charAt(nChars))) > availTextWidth) break;
                ++nChars;
            }
            text = String.valueOf(text.substring(0, nChars)) + clipString;
        }
        return text;
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TitlePane.this.iconify();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TitlePane.this.restore();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", TitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TitlePane.this.maximize();
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        SystemMenuBar() {
        }

        public void paint(Graphics g) {
            Image image;
            Frame frame = TitlePane.this.getFrame();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                g.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(TitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (TitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = 16;
            }
            int finalHeight = Math.max(fontHeight, iconHeight);
            return finalHeight;
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            if (TitlePane.this.getWindowDecorationStyle() != 1) {
                TitlePane.this.buttonsWidth = 0;
                return;
            }
            boolean leftToRight = TitlePane.this.window == null ? TitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : TitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = TitlePane.this.getWidth();
            int y = 3;
            int h = TitlePane.this.getHeight();
            if (TitlePane.this.closeButton != null && TitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = TitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = TitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int x = leftToRight ? w : 0;
            int spacing = 5;
            x = leftToRight ? spacing : w - buttonWidth - spacing;
            TitlePane.this.menuBar.setBounds(x, y, 16, 16);
            y = h / 2 - buttonHeight / 2;
            x = leftToRight ? w : 0;
            spacing = 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (TitlePane.this.closeButton != null) {
                TitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && TitlePane.this.toggleButton.getParent() != null) {
                spacing = 10;
                TitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (TitlePane.this.iconifyButton != null && TitlePane.this.iconifyButton.getParent() != null) {
                spacing = 2;
                TitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            TitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = TitlePane.this.getFrame();
                if (frame != null) {
                    TitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    TitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                TitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                TitlePane.this.revalidate();
                TitlePane.this.repaint();
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            TitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            TitlePane.this.setActive(false);
        }
    }
}

