/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringTabbedDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddForeignKeyColumnTableModel;

public class AddForeignKeyDialog
extends AbstractRefactoringTabbedDialog {
    private static final long serialVersionUID = -1468861452449568878L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddForeignKeyDialog.class);
    private static final ILogger log = LoggerController.createLogger(AddForeignKeyDialog.class);
    private final String _localTableName;
    private final String[] _localTableColumns;
    private String _referencedTable = "";
    private final HashMap<String, TableColumnInfo[]> _tables;
    private ColumnsTab _columnTab;
    private PropertiesTab _propertiesTab;
    private ActionTab _actionTab;

    public AddForeignKeyDialog(String localTable, String[] localTableColumns, HashMap<String, TableColumnInfo[]> tables) {
        super(new Dimension(430, 350));
        this._localTableName = localTable;
        this._localTableColumns = localTableColumns;
        this._tables = tables;
        this.init();
    }

    private void init() {
        this._columnTab = new ColumnsTab();
        this._propertiesTab = new PropertiesTab();
        this._actionTab = new ActionTab();
        this.pane.addTab(i18n.TABBEDPANE_PROPERTIES_LABEL, this._propertiesTab);
        this.pane.addTab(i18n.TABBEDPANE_COLUMNS_LABEL, this._columnTab);
        this.pane.addTab(i18n.TABBEDPANE_ACTION_LABEL, this._actionTab);
        this.setAllButtonEnabled(false);
        this.setTitle(i18n.DIALOG_TITLE);
    }

    private void checkInputCompletion() {
        if (this._columnTab._columTable.getRowCount() == 0) {
            this.setAllButtonEnabled(false);
            return;
        }
        this.setAllButtonEnabled(true);
    }

    public String getConstraintName() {
        return this._propertiesTab.getNameField();
    }

    public boolean isDeferrable() {
        return this._propertiesTab.getDeferrable();
    }

    public boolean isDeferred() {
        return this._propertiesTab.getDeferred();
    }

    public boolean isMatchFull() {
        return this._propertiesTab.getMatchFull();
    }

    public boolean isAutoFKIndex() {
        return this._propertiesTab.getAutoFK();
    }

    public String getFKIndexName() {
        return this._propertiesTab.getFkIndex();
    }

    public String getReferencedTable() {
        return this._propertiesTab.getReferencesField();
    }

    public Vector<String[]> getReferencedColumns() {
        return this._columnTab.getReferencedColumns();
    }

    public String getOnUpdateAction() {
        return this._actionTab.getSelectedUpdateAction();
    }

    public String getOnDeleteAction() {
        return this._actionTab.getSelectedDeleteAction();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    class ActionTab
    extends JPanel {
        private static final long serialVersionUID = -6693305068890653755L;
        private static final String NO_ACTION_COMMAND = "NO ACTION";
        private static final String RESTRICT_COMMAND = "RESTRICT";
        private static final String CASCADE_COMMAND = "CASCADE";
        private static final String SET_NULL_COMMAND = "SET NULL";
        private static final String SET_DEFAULT_COMMAND = "SET DEFAULT";
        private final ButtonGroup _onUpdateRadioButton = new ButtonGroup();
        private final ButtonGroup _onDeleteRadioButton = new ButtonGroup();

        public ActionTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            JPanel onUpdatePanel = new JPanel(new GridLayout(0, 1));
            JPanel onDeletePanel = new JPanel(new GridLayout(0, 1));
            onUpdatePanel.setBorder(BorderFactory.createTitledBorder(i18n.ACTION_ON_UPDATE_LABEL));
            onDeletePanel.setBorder(BorderFactory.createTitledBorder(i18n.ACTION_ON_DELETE_LABEL));
            JRadioButton upNoActionButton = new JRadioButton(i18n.ACTION_NO_ACTION_OPTION);
            upNoActionButton.setActionCommand(NO_ACTION_COMMAND);
            upNoActionButton.setSelected(true);
            JRadioButton deNoActionButton = new JRadioButton(i18n.ACTION_NO_ACTION_OPTION);
            deNoActionButton.setActionCommand(NO_ACTION_COMMAND);
            deNoActionButton.setSelected(true);
            JRadioButton upRestrictButton = new JRadioButton(i18n.ACTION_RESTRICT_OPTION);
            upRestrictButton.setActionCommand(RESTRICT_COMMAND);
            JRadioButton deRestrictButton = new JRadioButton(i18n.ACTION_RESTRICT_OPTION);
            deRestrictButton.setActionCommand(RESTRICT_COMMAND);
            JRadioButton upCascadeButton = new JRadioButton(i18n.ACTION_CASCADE_OPTION);
            upCascadeButton.setActionCommand(CASCADE_COMMAND);
            JRadioButton deCascadeButton = new JRadioButton(i18n.ACTION_CASCADE_OPTION);
            deCascadeButton.setActionCommand(CASCADE_COMMAND);
            JRadioButton upSetNullButton = new JRadioButton(i18n.ACTION_SET_NULL_OPTION);
            upSetNullButton.setActionCommand(SET_NULL_COMMAND);
            JRadioButton deSetNullButton = new JRadioButton(i18n.ACTION_SET_NULL_OPTION);
            deSetNullButton.setActionCommand(SET_NULL_COMMAND);
            JRadioButton upSetDefaultButton = new JRadioButton(i18n.ACTION_SET_DEFAULT_OPTION);
            upSetDefaultButton.setActionCommand(SET_DEFAULT_COMMAND);
            JRadioButton deSetDefaultButton = new JRadioButton(i18n.ACTION_SET_DEFAULT_OPTION);
            deSetDefaultButton.setActionCommand(SET_DEFAULT_COMMAND);
            this._onUpdateRadioButton.add(upNoActionButton);
            this._onUpdateRadioButton.add(upRestrictButton);
            this._onUpdateRadioButton.add(upCascadeButton);
            this._onUpdateRadioButton.add(upSetNullButton);
            this._onUpdateRadioButton.add(upSetDefaultButton);
            this._onDeleteRadioButton.add(deNoActionButton);
            this._onDeleteRadioButton.add(deRestrictButton);
            this._onDeleteRadioButton.add(deCascadeButton);
            this._onDeleteRadioButton.add(deSetNullButton);
            this._onDeleteRadioButton.add(deSetDefaultButton);
            onUpdatePanel.add(upNoActionButton);
            onUpdatePanel.add(upRestrictButton);
            onUpdatePanel.add(upCascadeButton);
            onUpdatePanel.add(upSetNullButton);
            onUpdatePanel.add(upSetDefaultButton);
            onDeletePanel.add(deNoActionButton);
            onDeletePanel.add(deRestrictButton);
            onDeletePanel.add(deCascadeButton);
            onDeletePanel.add(deSetNullButton);
            onDeletePanel.add(deSetDefaultButton);
            this.add((Component)onUpdatePanel, new GridBagConstraints(0, 0, 1, 0, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
            this.add((Component)onDeletePanel, new GridBagConstraints(1, 0, 1, 0, 0.0, 0.0, 17, 2, new Insets(0, 10, 0, 0), 0, 0));
        }

        public String getSelectedUpdateAction() {
            return this._onUpdateRadioButton.getSelection().getActionCommand();
        }

        public String getSelectedDeleteAction() {
            return this._onDeleteRadioButton.getSelection().getActionCommand();
        }
    }

    class ColumnsTab
    extends JPanel {
        private static final long serialVersionUID = 932908227634023574L;
        private JTable _columTable;
        private final AddForeignKeyColumnTableModel _columnTableModel = new AddForeignKeyColumnTableModel();
        private JComboBox localColumBox;
        private JComboBox referencingBox;
        private JButton removeButton;
        private JButton addButton;

        public ColumnsTab() {
            this.init();
            this.initData();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._columTable = new JTable();
            this._columTable.setModel(this._columnTableModel);
            this._columTable.setRowSelectionAllowed(true);
            this._columTable.setColumnSelectionAllowed(false);
            this._columTable.getTableHeader().setReorderingAllowed(false);
            this._columTable.setCellSelectionEnabled(false);
            this._columTable.setSelectionMode(0);
            this._columTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    ColumnsTab.this.removeButton.setEnabled(true);
                }
            });
            JScrollPane scrollTablePane = new JScrollPane(this._columTable);
            JLabel localColumLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.COLUMNS_LOCAL_COLUMN_LABEL, AddForeignKeyDialog.this.emptyBorder);
            JLabel referencingLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.COLUMNS_REFERENCING_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this.localColumBox = new JComboBox();
            this.localColumBox.setPreferredSize(AddForeignKeyDialog.this.mediumField);
            this.referencingBox = new JComboBox();
            this.localColumBox.setPreferredSize(AddForeignKeyDialog.this.mediumField);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 10, 10));
            this.addButton = new JButton(i18n.COLUMNS_ADD_BUTTON_LABEL);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String local = (String)ColumnsTab.this.localColumBox.getSelectedItem();
                    String ref = (String)ColumnsTab.this.referencingBox.getSelectedItem();
                    ColumnsTab.this.localColumBox.removeItem(local);
                    ColumnsTab.this.referencingBox.removeItem(ref);
                    ColumnsTab.this._columnTableModel.addColumn(new String[]{local, ref});
                    AddForeignKeyDialog.this._propertiesTab.enableReferencedComboBox(false);
                    if (ColumnsTab.this.localColumBox.getItemCount() == 0 || ColumnsTab.this.referencingBox.getItemCount() == 0) {
                        ColumnsTab.this.addButton.setEnabled(false);
                    }
                    AddForeignKeyDialog.this.checkInputCompletion();
                }
            });
            this.removeButton = new JButton(i18n.COLUMNS_REMOVE_BUTTON_LABEL);
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ColumnsTab.this._columTable.getSelectedRow();
                    if (index != -1) {
                        String[] removed = ColumnsTab.this._columnTableModel.deleteRow(index);
                        ColumnsTab.this.localColumBox.addItem(removed[0]);
                        ColumnsTab.this.referencingBox.addItem(removed[1]);
                        ColumnsTab.this.addButton.setEnabled(true);
                        if (ColumnsTab.this._columnTableModel.getRowCount() == 0) {
                            ColumnsTab.this.removeButton.setEnabled(false);
                            AddForeignKeyDialog.this._propertiesTab.enableReferencedComboBox(true);
                        } else {
                            int deleteIndex = 0;
                            if (index > 0) {
                                deleteIndex = index - 1;
                            }
                            ColumnsTab.this._columTable.getSelectionModel().setSelectionInterval(0, deleteIndex);
                        }
                    }
                    AddForeignKeyDialog.this.checkInputCompletion();
                }
            });
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.removeButton);
            this.add((Component)scrollTablePane, new GridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)localColumLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.add((Component)this.localColumBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.add((Component)referencingLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.add((Component)this.referencingBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.add((Component)buttonPanel, new GridBagConstraints(0, 5, 2, 0, 1.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void initData() {
            this.setLocalColumns(AddForeignKeyDialog.this._localTableColumns);
            this.setReferencedColumns(AddForeignKeyDialog.this._localTableName);
        }

        public void setReferencedColumns(String tableName) {
            TableColumnInfo[] tableColumns = (TableColumnInfo[])AddForeignKeyDialog.this._tables.get(tableName);
            Vector<String> columns = new Vector<String>();
            for (TableColumnInfo columnInfo : tableColumns) {
                columns.add(columnInfo.getColumnName());
            }
            this.setReferencedColumns(columns.toArray(new String[0]));
        }

        private void setLocalColumns(String[] localColums) {
            this.localColumBox.removeAllItems();
            for (String colum : localColums) {
                this.localColumBox.addItem(colum);
            }
        }

        private void setReferencedColumns(String[] refColums) {
            this.referencingBox.removeAllItems();
            for (String ref : refColums) {
                this.referencingBox.addItem(ref);
            }
        }

        public Vector<String[]> getReferencedColumns() {
            return this._columnTableModel.getRowData();
        }
    }

    class PropertiesTab
    extends JPanel {
        private static final long serialVersionUID = -8311422583709806081L;
        private JComboBox _referencesField;
        private JTextField _nameField;
        private JCheckBox _deferrableBox;
        private JCheckBox _deferredBox;
        private JCheckBox _matchFullBox;
        private JCheckBox _autoFKBox;
        private JTextField _fkIndexBox;

        public PropertiesTab() {
            this.init();
            this.initData();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            JLabel nameLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.PROPERTIES_NAME_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this._nameField = new JTextField();
            this._nameField.setPreferredSize(AddForeignKeyDialog.this.mediumField);
            JLabel referencesLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.PROPERTIES_REFERENCES_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this._referencesField = new JComboBox();
            this._referencesField.setPreferredSize(AddForeignKeyDialog.this.mediumField);
            this._referencesField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddForeignKeyDialog.this._referencedTable = (String)PropertiesTab.this._referencesField.getSelectedItem();
                    AddForeignKeyDialog.this._columnTab.setReferencedColumns(AddForeignKeyDialog.this._referencedTable);
                }
            });
            JLabel deferrableLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.PROPERTIES_DEFERABLE_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this._deferrableBox = new JCheckBox();
            this._deferrableBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (!PropertiesTab.this._deferrableBox.isSelected()) {
                        PropertiesTab.this._deferredBox.setSelected(false);
                    }
                }
            });
            JLabel deferredLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.PROPERTIES_DEFERRED_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this._deferredBox = new JCheckBox();
            JLabel matchFullLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.PROPERTIES_MATCH_FULL_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this._matchFullBox = new JCheckBox();
            JLabel autoFKLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.PROPERTIES_AUTO_FK_INDEX_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this._autoFKBox = new JCheckBox();
            this._autoFKBox.setSelected(true);
            this._autoFKBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (PropertiesTab.this._autoFKBox.isSelected()) {
                        PropertiesTab.this._fkIndexBox.setEnabled(true);
                    } else {
                        PropertiesTab.this._fkIndexBox.setEnabled(false);
                    }
                }
            });
            JLabel fkIndexLabel = AddForeignKeyDialog.this.getBorderedLabel(i18n.PROPERTIES_FK_INDEX_NAME_LABEL, AddForeignKeyDialog.this.emptyBorder);
            this._fkIndexBox = new JTextField("fki_");
            this._fkIndexBox.setPreferredSize(AddForeignKeyDialog.this.mediumField);
            GridBagConstraints gbc = AddForeignKeyDialog.this.c;
            gbc.gridx = 0;
            gbc.gridy = -1;
            this.add((Component)nameLabel, AddForeignKeyDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._nameField, AddForeignKeyDialog.this.getFieldConstraints(gbc));
            this.add((Component)referencesLabel, AddForeignKeyDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._referencesField, AddForeignKeyDialog.this.getFieldConstraints(gbc));
            this.add((Component)deferrableLabel, AddForeignKeyDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._deferrableBox, AddForeignKeyDialog.this.getFieldConstraints(gbc));
            this.add((Component)deferredLabel, AddForeignKeyDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._deferredBox, AddForeignKeyDialog.this.getFieldConstraints(gbc));
            this.add((Component)matchFullLabel, AddForeignKeyDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._matchFullBox, AddForeignKeyDialog.this.getFieldConstraints(gbc));
            this.add((Component)autoFKLabel, AddForeignKeyDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._autoFKBox, AddForeignKeyDialog.this.getFieldConstraints(gbc));
            this.add((Component)fkIndexLabel, AddForeignKeyDialog.this.getLabelConstraints(gbc));
            this.add((Component)this._fkIndexBox, AddForeignKeyDialog.this.getFieldConstraints(gbc));
        }

        public void setReferencesTable(String[] tableList) {
            for (String table : tableList) {
                this._referencesField.addItem(table);
            }
        }

        public void enableReferencedComboBox(boolean enable) {
            this._referencesField.setEnabled(enable);
        }

        public String getNameField() {
            return this._nameField.getText();
        }

        public String getReferencesField() {
            return this._referencesField.getSelectedItem().toString();
        }

        public boolean getDeferrable() {
            return this._deferrableBox.isSelected();
        }

        public boolean getDeferred() {
            return this._deferredBox.isSelected();
        }

        public boolean getMatchFull() {
            return this._matchFullBox.isSelected();
        }

        public boolean getAutoFK() {
            return this._autoFKBox.isSelected();
        }

        public String getFkIndex() {
            return this._fkIndexBox.getText();
        }

        private void initData() {
            Object[] tables = AddForeignKeyDialog.this._tables.keySet().toArray(new String[0]);
            Arrays.sort(tables);
            this.setReferencesTable((String[])tables);
        }
    }

    protected static interface i18n {
        public static final String DIALOG_TITLE = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.title");
        public static final String TABBEDPANE_PROPERTIES_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.propertiesTabName");
        public static final String TABBEDPANE_COLUMNS_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.columnsTabName");
        public static final String TABBEDPANE_ACTION_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.actionTabName");
        public static final String PROPERTIES_NAME_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.nameLabel");
        public static final String PROPERTIES_REFERENCES_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.referencesLabel");
        public static final String PROPERTIES_DEFERABLE_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.defereableLabel");
        public static final String PROPERTIES_DEFERRED_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.deferredLabel");
        public static final String PROPERTIES_MATCH_FULL_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.matchFullLabel");
        public static final String PROPERTIES_AUTO_FK_INDEX_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.autoFKIndexLabel");
        public static final String PROPERTIES_FK_INDEX_NAME_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.fkIndexNameLabel");
        public static final String PROPERTIES_COMMENT_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.commentLabel");
        public static final String COLUMNS_LOCAL_COLUMN_HEADER = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.localTableHeader");
        public static final String COLUMNS_LOCAL_COLUMN_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.localColumnLabel");
        public static final String COLUMNS_REFERENCED_HEADER = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.referenedTableHeader");
        public static final String COLUMNS_REFERENCING_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.referencingLabel");
        public static final String COLUMNS_ADD_BUTTON_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.addButtonLabel");
        public static final String COLUMNS_REMOVE_BUTTON_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.removeButtonLabel");
        public static final String ACTION_ON_UPDATE_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.onUpdateLabel");
        public static final String ACTION_ON_DELETE_LABEL = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.onDeleteLabel");
        public static final String ACTION_NO_ACTION_OPTION = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.noActionOption");
        public static final String ACTION_RESTRICT_OPTION = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.restrictOption");
        public static final String ACTION_CASCADE_OPTION = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.cascadeOption");
        public static final String ACTION_SET_NULL_OPTION = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.setNullOption");
        public static final String ACTION_SET_DEFAULT_OPTION = AddForeignKeyDialog.access$000().getString("ForeignKeyDialog.setDefaultOption");
    }
}

